/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.support.lock;

import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.compatibility.Compatibility;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class LocketteXCompatibility
extends Compatibility {
    private static final String eventClassPath = "pro.dracarys.LocketteX.api.PlayerProtectBlockEvent";
    private Listener instance;

    @Override
    public boolean isValid(Server server) {
        return server.getPluginManager().isPluginEnabled("LocketteX");
    }

    @Override
    protected void enable(DeathChestPlugin plugin) {
        try {
            Class<?> aClass1 = Class.forName(eventClassPath);
            if (!Event.class.isAssignableFrom(aClass1)) {
                plugin.getLogger().severe("Event is not assignable from pro.dracarys.LocketteX.api.PlayerProtectBlockEvent");
                plugin.getLogger().severe("Cannot initialize the LocketteX compatibility");
                return;
            }
            Class<Event> subclass = aClass1.asSubclass(Event.class);
            this.instance = new Listener(){};
            Bukkit.getPluginManager().registerEvent(subclass, this.instance, EventPriority.NORMAL, (listener, event) -> {
                try {
                    Location location = (Location)subclass.getMethod("getLocation", new Class[0]).invoke((Object)event, new Object[0]);
                    if (plugin.getDeathChestController().getChest(location) != null) {
                        subclass.getMethod("setCancelled", Boolean.TYPE).invoke((Object)event, true);
                        Player player = (Player)subclass.getMethod("getPlayer", new Class[0]).invoke((Object)event, new Object[0]);
                        player.sendMessage(plugin.getPrefix() + "\u00a7cYou cannot lock this chest.");
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    HandlerList.unregisterAll((Listener)this.instance);
                    plugin.getLogger().severe("Failed to handle the LocketteX event.");
                }
            }, (Plugin)plugin, true);
        }
        catch (ClassNotFoundException e) {
            plugin.getLogger().severe("Failed to initialize the LocketteX compatibility");
        }
    }

    @Override
    protected void disable(DeathChestPlugin plugin) {
        HandlerList.unregisterAll((Listener)this.instance);
    }
}

