/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.support.lock;

import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.compatibility.Compatibility;
import com.github.devcyntrix.deathchest.controller.DeathChestController;
import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class LWCCompatibility
extends Compatibility {
    @Override
    public boolean isValid(Server server) {
        return server.getPluginManager().isPluginEnabled("LWC");
    }

    @Override
    protected void enable(DeathChestPlugin plugin) {
        try {
            Class.forName("com.griefcraft.lwc.LWC");
            LWC.getInstance().getModuleLoader().registerModule((Plugin)plugin, (Module)new LWCModule(plugin));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void disable(DeathChestPlugin plugin) {
        try {
            Class.forName("com.griefcraft.lwc.LWC");
            LWC.getInstance().getModuleLoader().removeModules((Plugin)plugin);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static class LWCModule
    extends JavaModule {
        private final DeathChestPlugin plugin;

        public void onRegisterProtection(LWCProtectionRegisterEvent event) {
            DeathChestController controller = this.plugin.getDeathChestController();
            if (controller.getChest(event.getBlock().getLocation()) != null) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(this.plugin.getPrefix() + "\u00a7cYou cannot lock this chest.");
            }
        }

        public LWCModule(DeathChestPlugin plugin) {
            this.plugin = plugin;
        }
    }
}

