/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.report;

import com.github.devcyntrix.deathchest.api.report.Report;
import com.github.devcyntrix.deathchest.api.report.ReportManager;
import com.github.devcyntrix.deathchest.util.adapter.DurationAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.util.ISO8601Utils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GsonReportManager
implements ReportManager {
    private static final Logger LOG = Logger.getLogger(GsonReportManager.class.getName());
    private static final String format = "report-%s.json";
    private static final String reportPattern = "^report-(.*).json$";
    private final Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat(2, 2).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).create();
    private final File folder;

    public GsonReportManager(File folder) {
        this.folder = folder;
        if (!this.folder.isDirectory() && !this.folder.mkdirs()) {
            throw new RuntimeException("Failed to create report directory");
        }
    }

    @Override
    public void addReport(@NotNull Report report) {
        boolean delete;
        File file = new File(this.folder, format.formatted(ISO8601Utils.format((Date)report.date())));
        if (file.exists() && !(delete = file.delete())) {
            throw new RuntimeException("Failed to update report file");
        }
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson((Object)report, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public Report getLatestReport() {
        TreeSet<Date> reportDates = this.getReportDates();
        if (reportDates.isEmpty()) {
            return null;
        }
        Date last = reportDates.last();
        File file = new File(this.folder, format.formatted(ReportManager.formatISO(last)));
        return this.parseReport(file);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Report> getReports() {
        HashSet<Report> reports = new HashSet<Report>();
        File[] files = this.folder.listFiles(file -> file.isFile() && file.getName().matches(reportPattern));
        if (files == null) {
            return reports;
        }
        for (File file2 : files) {
            Report report = this.parseReport(file2);
            if (report == null) continue;
            reports.add(report);
        }
        return reports;
    }

    @Override
    @NotNull
    public TreeSet<Date> getReportDates() {
        TreeSet<Date> list = new TreeSet<Date>(Date::compareTo);
        File[] files = this.folder.listFiles(file -> file.isFile() && file.getName().matches(reportPattern));
        if (files == null) {
            return list;
        }
        Pattern pattern = Pattern.compile(reportPattern);
        for (File file2 : files) {
            Matcher matcher = pattern.matcher(file2.getName());
            if (!matcher.find()) continue;
            String group = matcher.group(1);
            Date date = ReportManager.parseISO(group);
            if (date == null) {
                LOG.log(Level.SEVERE, "Failed to parse date format of file name " + group);
                continue;
            }
            list.add(date);
        }
        return list;
    }

    @Override
    public boolean deleteReport(@NotNull Date date) {
        File file = new File(this.folder, format.formatted(ISO8601Utils.format((Date)date)));
        return file.delete();
    }

    @Override
    public void deleteReports() {
        File[] files = this.folder.listFiles(file -> file.isFile() && file.getName().matches(reportPattern));
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            if (file2.delete()) continue;
            LOG.warning("Failed to delete file: " + String.valueOf(file2));
        }
    }

    private Report parseReport(File file) {
        Report report;
        FileReader reader = new FileReader(file);
        try {
            report = (Report)this.gson.fromJson((Reader)reader, Report.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to read report", e);
                return null;
            }
        }
        reader.close();
        return report;
    }
}

