/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.listener;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.event.DeathChestSpawnEvent;
import com.github.devcyntrix.deathchest.api.event.PreDeathChestSpawnEvent;
import com.github.devcyntrix.deathchest.config.ChangeDeathMessageOptions;
import com.github.devcyntrix.deathchest.config.DeathChestConfig;
import com.github.devcyntrix.deathchest.config.NoExpirationPermission;
import com.github.devcyntrix.deathchest.config.ThiefProtectionOptions;
import com.github.devcyntrix.deathchest.controller.LastSafeLocationController;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.text.StringSubstitutor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class SpawnChestListener
implements Listener {
    private final DeathChestPlugin plugin;
    private final Set<Player> set = Collections.newSetFromMap(new WeakHashMap());

    public SpawnChestListener(DeathChestPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.set.remove(event.getPlayer());
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        this.set.remove(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        long expireAt;
        this.plugin.debug(0, new Object[]{"Spawning death chest..."});
        Player player = event.getEntity();
        this.plugin.debug(1, new Object[]{"Checking multiple deaths at once..."});
        if (this.set.contains(player)) {
            event.getDrops().clear();
            return;
        }
        this.set.add(player);
        World world = player.getWorld();
        DeathChestConfig config = this.plugin.getDeathChestConfig();
        this.plugin.debug(1, new Object[]{"Checking keep inventory..."});
        if (event.getKeepInventory()) {
            return;
        }
        this.plugin.debug(1, new Object[]{"Removing air and blacklisted items..."});
        List drops = event.getDrops();
        boolean removed = drops.removeIf(itemStack -> itemStack == null || itemStack.getType().isAir() || itemStack.getAmount() <= 0 || !this.plugin.getBlacklist().isValidItem((ItemStack)itemStack));
        if (removed) {
            this.plugin.debug(2, new Object[]{"Inventory has been updated."});
        }
        if (drops.isEmpty()) {
            this.plugin.debug(1, new Object[]{"Clearing drops because the inventory was empty after removing blacklisted items"});
            return;
        }
        ItemStack[] items = (ItemStack[])event.getDrops().toArray(ItemStack[]::new);
        this.plugin.debug(1, new Object[]{"Checking world filter..."});
        if (!config.worldFilterConfig().test(player.getWorld())) {
            return;
        }
        this.plugin.debug(1, new Object[]{"Getting expiration time..."});
        Duration expiration = config.chestOptions().expiration();
        if (expiration == null) {
            expiration = Duration.ofSeconds(-1L);
        }
        this.plugin.debug(1, new Object[]{"Checking no expiration permission..."});
        NoExpirationPermission permission = config.chestOptions().noExpirationPermission();
        boolean expires = !permission.enabled() || !player.hasPermission(permission.permission());
        long createdAt = System.currentTimeMillis();
        long l = expireAt = !expiration.isNegative() && !expiration.isZero() && expires ? createdAt + expiration.toMillis() : -1L;
        if (expireAt <= 0L) {
            this.plugin.debug(1, new Object[]{"The chest will never expire"});
        } else {
            this.plugin.debug(1, new Object[]{"The chest will expire at " + String.valueOf(new Date(expireAt))});
        }
        LastSafeLocationController controller = this.plugin.getLastSafeLocationController();
        controller.updatePosition(player);
        Location lastSafePos = controller.getPosition(player);
        if (lastSafePos == null) {
            lastSafePos = player.getLocation().getBlock().getLocation().clone();
        } else if (Objects.equals(player.getLocation().getWorld(), lastSafePos.getWorld()) && player.getLocation().distanceSquared(lastSafePos) >= 400.0) {
            lastSafePos = player.getLocation().getBlock().getLocation().clone();
            for (int it = 0; lastSafePos.getBlock().isEmpty() && lastSafePos.getBlockY() >= world.getMinHeight() && it <= 20; ++it) {
                lastSafePos = lastSafePos.subtract(0.0, 1.0, 0.0);
            }
            if (!lastSafePos.getBlock().isEmpty()) {
                lastSafePos.add(0.0, 1.0, 0.0);
            }
        }
        lastSafePos.setY((double)Math.min(Math.max(lastSafePos.getBlockY(), world.getMinHeight()), world.getMaxHeight() - 1));
        this.plugin.debug(1, new Object[]{"Checking protection service..."});
        boolean build = this.plugin.getProtectionService().canBuild(player, lastSafePos, Material.CHEST);
        if (!build) {
            return;
        }
        ChangeDeathMessageOptions changeDeathMessageOptions = config.changeDeathMessageOptions();
        if (changeDeathMessageOptions.enabled()) {
            this.plugin.debug(1, new Object[]{"Changing death message..."});
            if (changeDeathMessageOptions.message() != null && lastSafePos.getWorld() != null) {
                StringSubstitutor substitution = new StringSubstitutor(Map.of("x", lastSafePos.getBlockX(), "y", lastSafePos.getBlockY(), "z", lastSafePos.getBlockZ(), "world", lastSafePos.getWorld().getName(), "player_name", player.getName(), "player_display_name", player.getDisplayName()));
                event.setDeathMessage(Arrays.stream(changeDeathMessageOptions.message()).map(arg_0 -> ((StringSubstitutor)substitution).replace(arg_0)).map(s -> {
                    if (DeathChestPlugin.isPlaceholderAPIEnabled()) {
                        return PlaceholderAPI.setPlaceholders((Player)player, (String)s);
                    }
                    return s;
                }).collect(Collectors.joining("\n")));
            } else {
                event.setDeathMessage(null);
            }
        }
        try {
            ThiefProtectionOptions thiefProtectionOptions = config.chestOptions().thiefProtectionOptions();
            boolean protectedChest = thiefProtectionOptions.enabled() && player.hasPermission(thiefProtectionOptions.permission()) && config.worldChestProtectionFilter().test(lastSafePos.getWorld());
            this.plugin.debug(1, new Object[]{"Protected chest: %s".formatted(protectedChest)});
            PreDeathChestSpawnEvent preSpawn = new PreDeathChestSpawnEvent(player, lastSafePos, protectedChest, createdAt, expireAt, items);
            Bukkit.getPluginManager().callEvent((Event)preSpawn);
            if (preSpawn.isCancelled()) {
                return;
            }
            lastSafePos = preSpawn.getLocation();
            protectedChest = preSpawn.isProtectedChest();
            createdAt = preSpawn.getCreatedAt();
            expireAt = preSpawn.getExpireAt();
            items = preSpawn.getItems();
            DeathChestModel deathChest = this.plugin.createDeathChest(lastSafePos, createdAt, expireAt, player, protectedChest, items);
            DeathChestSpawnEvent deathChestSpawnEvent = new DeathChestSpawnEvent(player, deathChest);
            Bukkit.getPluginManager().callEvent((Event)deathChestSpawnEvent);
            this.plugin.debug(1, new Object[]{"Clearing drops..."});
            event.getDrops().clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

