/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.listener;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.audit.AuditAction;
import com.github.devcyntrix.deathchest.api.audit.AuditItem;
import com.github.devcyntrix.deathchest.api.audit.info.DestroyChestInfo;
import com.github.devcyntrix.deathchest.api.audit.info.DestroyReason;
import com.github.devcyntrix.deathchest.config.ThiefProtectionOptions;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lidded;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestDestroyListener
implements Listener {
    private final DeathChestPlugin plugin;

    public ChestDestroyListener(DeathChestPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof DeathChestModel)) {
            return;
        }
        final DeathChestModel model = (DeathChestModel)inventoryHolder;
        HumanEntity human = event.getPlayer();
        BlockState state = model.getLocation().getBlock().getState();
        if (state instanceof Lidded) {
            Lidded lidded = (Lidded)state;
            if (human.getGameMode() != GameMode.SPECTATOR) {
                try {
                    lidded.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!inventory.isEmpty()) {
            return;
        }
        DestroyReason reason = DestroyReason.PLAYER;
        if (!human.equals((Object)model.getOwner())) {
            reason = DestroyReason.THIEF;
        }
        this.plugin.getAuditManager().audit(new AuditItem(new Date(), AuditAction.DESTROY_CHEST, new DestroyChestInfo(model, reason, Map.of("player", human))));
        new BukkitRunnable(){

            public void run() {
                ChestDestroyListener.this.plugin.getDeathChestController().destroyChest(model);
            }
        }.runTask((Plugin)this.plugin);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        DeathChestModel model = this.plugin.getDeathChestController().getChest(block.getLocation());
        if (model == null) {
            return;
        }
        Player player = event.getPlayer();
        event.setCancelled(true);
        if (!this.plugin.getDeathChestController().isAccessibleBy(model, player)) {
            ThiefProtectionOptions protectionOptions = this.plugin.getDeathChestConfig().chestOptions().thiefProtectionOptions();
            protectionOptions.playSound(player, block.getLocation());
            protectionOptions.notify(player);
            return;
        }
        Arrays.stream(model.getInventory().getContents()).filter(Objects::nonNull).forEach(itemStack -> model.getWorld().dropItemNaturally(model.getLocation(), itemStack));
        this.plugin.getAuditManager().audit(new AuditItem(new Date(), AuditAction.DESTROY_CHEST, new DestroyChestInfo(model, DestroyReason.BREAK, Map.of("player", player))));
        model.getInventory().clear();
        this.plugin.getDeathChestController().destroyChest(model);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockExplode(BlockExplodeEvent event) {
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Block next = (Block)iterator.next();
            DeathChestModel model = this.plugin.getDeathChestController().getChest(next.getLocation());
            if (model == null) continue;
            if (this.plugin.getDeathChestConfig().chestOptions().blastProtection()) {
                iterator.remove();
                continue;
            }
            for (ItemStack content : model.getInventory().getContents()) {
                if (content == null) continue;
                model.getWorld().dropItemNaturally(model.getLocation(), content);
            }
            model.getInventory().clear();
            Block block = event.getBlock();
            this.plugin.getAuditManager().audit(new AuditItem(new Date(), AuditAction.DESTROY_CHEST, new DestroyChestInfo(model, DestroyReason.BLOCK_EXPLOSION, Map.of("block", block))));
            this.plugin.getDeathChestController().destroyChest(model);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockExplode(EntityExplodeEvent event) {
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Block next = (Block)iterator.next();
            DeathChestModel model = this.plugin.getDeathChestController().getChest(next.getLocation());
            if (model == null) continue;
            if (this.plugin.getDeathChestConfig().chestOptions().blastProtection()) {
                iterator.remove();
                continue;
            }
            for (ItemStack content : model.getInventory().getContents()) {
                if (content == null) continue;
                model.getWorld().dropItemNaturally(model.getLocation(), content);
            }
            model.getInventory().clear();
            Entity entity = event.getEntity();
            this.plugin.getAuditManager().audit(new AuditItem(new Date(), AuditAction.DESTROY_CHEST, new DestroyChestInfo(model, DestroyReason.ENTITY_EXPLOSION, Map.of("entity", entity))));
            this.plugin.getDeathChestController().destroyChest(model);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block next = event.getBlock();
        DeathChestModel model = this.plugin.getDeathChestController().getChest(next.getLocation());
        if (model == null) {
            return;
        }
        event.setCancelled(true);
    }
}

