/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.controller;

import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.config.DeathChestConfig;
import com.github.devcyntrix.deathchest.util.update.HangarUpdateChecker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Singleton
public class UpdateController
implements Closeable {
    private String newestVersion;
    private final BukkitTask updateScheduler;
    private final List<Consumer<String>> subscriberList = new ArrayList<Consumer<String>>();

    @Inject
    public UpdateController(DeathChestPlugin plugin) {
        HangarUpdateChecker checker = new HangarUpdateChecker(plugin);
        this.updateScheduler = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            block21: {
                String version = checker.getLatestRelease();
                if (version == null) {
                    return;
                }
                if (plugin.getDescription().getVersion().equals(version)) {
                    return;
                }
                if (version.equals(this.newestVersion)) {
                    return;
                }
                this.newestVersion = version;
                this.subscriberList.forEach(subscriber -> subscriber.accept(this.newestVersion));
                DeathChestConfig config = plugin.getDeathChestConfig();
                if (config.autoUpdate()) {
                    try (InputStream download = checker.download(this.newestVersion);){
                        if (download == null) break block21;
                        File updateFolder = Bukkit.getUpdateFolderFile();
                        if (!updateFolder.isDirectory() && !updateFolder.mkdirs()) {
                            return;
                        }
                        File updateFile = new File(updateFolder, plugin.getFile().getName());
                        if (!updateFile.isFile() && !updateFile.createNewFile()) {
                            return;
                        }
                        try (FileOutputStream stream = new FileOutputStream(updateFile);){
                            download.transferTo(stream);
                        }
                    }
                    catch (IOException e) {
                        plugin.getLogger().log(Level.WARNING, "Failed to write the download on the disk.", e);
                    }
                }
            }
        }, 0L, 36000L);
    }

    public void subscribe(@NotNull Consumer<String> subscriber) {
        this.subscriberList.add(subscriber);
    }

    @Override
    public void close() {
        if (this.updateScheduler != null) {
            this.updateScheduler.cancel();
        }
    }

    public String getNewestVersion() {
        return this.newestVersion;
    }

    public BukkitTask getUpdateScheduler() {
        return this.updateScheduler;
    }

    public List<Consumer<String>> getSubscriberList() {
        return this.subscriberList;
    }
}

