/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.controller;

import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.util.LastLocationMetadata;
import com.google.inject.Singleton;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

@Singleton
public class LastSafeLocationController {
    private static final String lastSafePosition = "last-safe-position";
    private final DeathChestPlugin plugin;

    public LastSafeLocationController(DeathChestPlugin plugin) {
        this.plugin = plugin;
    }

    public void updatePosition(Player player) {
        Location location = player.getLocation().clone().subtract(0.0, 0.2, 0.0);
        Block block = location.getBlock();
        if (block.isEmpty()) {
            return;
        }
        Location blockLoc = player.getLocation().getBlock().getLocation();
        if (!this.plugin.canPlaceChestAt(blockLoc)) {
            return;
        }
        List metadata = player.getMetadata(lastSafePosition);
        if (metadata.isEmpty()) {
            player.setMetadata(lastSafePosition, (MetadataValue)new LastLocationMetadata(this.plugin, blockLoc.clone()));
        } else {
            MetadataValue metadataValue = (MetadataValue)metadata.get(0);
            if (!(metadataValue instanceof LastLocationMetadata)) {
                return;
            }
            LastLocationMetadata meta = (LastLocationMetadata)metadataValue;
            if (System.currentTimeMillis() - meta.getUpdatedAt() < 500L) {
                return;
            }
            meta.setLocation(blockLoc.clone());
        }
    }

    @Nullable
    public Location getPosition(Player player) {
        List metadata = player.getMetadata(lastSafePosition);
        if (metadata.isEmpty()) {
            return null;
        }
        MetadataValue metadataValue = (MetadataValue)metadata.get(0);
        if (!(metadataValue instanceof LastLocationMetadata)) {
            return null;
        }
        LastLocationMetadata meta = (LastLocationMetadata)metadataValue;
        return meta.value();
    }
}

