/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.controller;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.ChestView;
import com.github.devcyntrix.deathchest.api.audit.AuditAction;
import com.github.devcyntrix.deathchest.api.audit.AuditItem;
import com.github.devcyntrix.deathchest.api.audit.AuditManager;
import com.github.devcyntrix.deathchest.api.audit.info.CreateChestInfo;
import com.github.devcyntrix.deathchest.api.event.DeathChestDestroyEvent;
import com.github.devcyntrix.deathchest.api.storage.DeathChestStorage;
import com.github.devcyntrix.deathchest.config.DeathChestConfig;
import com.github.devcyntrix.deathchest.config.InventoryOptions;
import com.github.devcyntrix.deathchest.config.ThiefProtectionOptions;
import com.github.devcyntrix.deathchest.util.ChestModelStringLookup;
import com.github.devcyntrix.deathchest.util.DurationFormatter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class DeathChestController
implements Closeable {
    private final DeathChestPlugin plugin;
    private final Logger logger;
    private final AuditManager auditManager;
    private final DeathChestStorage storage;
    private final Set<ChestView> listeners = new HashSet<ChestView>();
    protected final Table<World, Location, DeathChestModel> loadedChests = HashBasedTable.create();
    private final DurationFormatter durationFormatter;

    public DeathChestController(DeathChestPlugin plugin, Logger logger, AuditManager auditManager, DeathChestStorage storage) {
        this.plugin = plugin;
        this.logger = logger;
        this.auditManager = auditManager;
        this.storage = storage;
        this.durationFormatter = new DurationFormatter(this.getConfig().durationFormat());
    }

    public void registerAdapter(ChestView adapter) {
        this.listeners.add(adapter);
    }

    public void loadChests() {
        Bukkit.getWorlds().forEach(this::loadChests);
    }

    public void loadChests(World world) {
        this.storage.getChests(world).forEach(model -> {
            for (ChestView listener : this.listeners) {
                listener.onLoad((DeathChestModel)model);
            }
            this.loadedChests.put((Object)model.getWorld(), (Object)model.getLocation(), model);
        });
        this.logger.info(this.loadedChests.row((Object)world).size() + " death chests loaded in world \"" + world.getName() + "\"");
        long time = System.currentTimeMillis();
        this.logger.info("  Of these %d have expired".formatted(this.loadedChests.row((Object)world).values().stream().filter(model1 -> model1.getExpireAt() < time).count()));
    }

    @NotNull
    public DeathChestModel createChest(@NotNull Location location, long expireAt, @Nullable Player player, ItemStack ... items) {
        boolean protectedChest = player != null && player.hasPermission(this.getConfig().chestOptions().thiefProtectionOptions().permission());
        return this.createChest(location, System.currentTimeMillis(), expireAt, player, protectedChest, items);
    }

    @NotNull
    public DeathChestModel createChest(@NotNull Location location, long createdAt, long expireAt, @Nullable Player player, boolean isProtected, ItemStack ... items) {
        DeathChestModel model = new DeathChestModel(location, createdAt, expireAt, (OfflinePlayer)player, isProtected);
        StringSubstitutor substitution = new StringSubstitutor((StringLookup)new ChestModelStringLookup(this, this.plugin.getDeathChestConfig(), model, this.durationFormatter));
        InventoryOptions inventoryOptions = this.getConfig().inventoryOptions();
        model.setInventory(inventoryOptions.createInventory(model, title -> {
            title = substitution.replace(title);
            if (DeathChestPlugin.isPlaceholderAPIEnabled()) {
                title = PlaceholderAPI.setPlaceholders((Player)player, (String)title);
            }
            return title;
        }, items));
        for (ChestView listener : this.listeners) {
            listener.onCreate(model);
        }
        this.loadedChests.put((Object)model.getWorld(), (Object)model.getLocation(), (Object)model);
        if (this.auditManager != null) {
            this.auditManager.audit(new AuditItem(new Date(), AuditAction.CREATE_CHEST, new CreateChestInfo(model)));
        }
        return model;
    }

    @Nullable
    public DeathChestModel getChest(@NotNull Location location) {
        return (DeathChestModel)this.loadedChests.get((Object)location.getWorld(), (Object)location);
    }

    @NotNull
    public Collection<DeathChestModel> getChests() {
        return this.loadedChests.values();
    }

    @NotNull
    public Collection<DeathChestModel> getChests(World world) {
        return this.loadedChests.row((Object)world).values();
    }

    public long getProtectionExpiresAt(@NotNull DeathChestModel model) {
        ThiefProtectionOptions protectionOptions = this.plugin.getDeathChestConfig().chestOptions().thiefProtectionOptions();
        long remainingTime = 0L;
        long expiration = protectionOptions.expiration().toMillis();
        if (expiration > 0L) {
            remainingTime = expiration + model.getCreatedAt();
        }
        return remainingTime;
    }

    public long getRemainingProtection(@NotNull DeathChestModel model) {
        long protectionExpiresAt = this.getProtectionExpiresAt(model);
        if (protectionExpiresAt <= 0L) {
            return 0L;
        }
        return protectionExpiresAt - System.currentTimeMillis();
    }

    public boolean isAccessibleBy(@NotNull DeathChestModel model, @NotNull Player player) {
        ThiefProtectionOptions protectionOptions = this.plugin.getDeathChestConfig().chestOptions().thiefProtectionOptions();
        long remainingTime = this.getRemainingProtection(model);
        return !model.isProtected() || model.getOwner() == null || model.getOwner().getUniqueId().equals(player.getUniqueId()) || player.hasPermission(protectionOptions.bypassPermission()) || remainingTime < 0L;
    }

    public void destroyChest(DeathChestModel model) {
        if (model.isDeleting()) {
            return;
        }
        model.setDeleting(true);
        model.cancelTasks();
        for (ChestView listener : this.listeners) {
            listener.onDestroy(model);
        }
        if ((model = (DeathChestModel)this.loadedChests.remove((Object)model.getWorld(), (Object)model.getLocation())) == null) {
            throw new IllegalArgumentException("Invalid model");
        }
        this.storage.remove(model);
        Bukkit.getPluginManager().callEvent((Event)new DeathChestDestroyEvent(model));
    }

    @Override
    public void close() {
        this.unloadChests();
    }

    private void unloadChests() {
        this.saveChests();
        this.loadedChests.values().forEach(model -> {
            this.listeners.forEach(listener -> listener.onUnload((DeathChestModel)model));
            model.cancelTasks();
        });
        this.loadedChests.clear();
    }

    public void unloadChests(World world, boolean save) {
        if (save) {
            this.saveChests(world);
        }
        Collection values = this.loadedChests.row((Object)world).values();
        for (DeathChestModel model : values) {
            this.listeners.forEach(listener -> listener.onUnload(model));
            model.cancelTasks();
        }
        values.clear();
    }

    public void saveChests() {
        this.storage.update(this.loadedChests.values());
    }

    public void saveChests(@NotNull World world) {
        Collection<DeathChestModel> values = this.loadedChests.row((Object)world).values();
        this.storage.update(values);
    }

    public DeathChestConfig getConfig() {
        return this.plugin.getDeathChestConfig();
    }
}

