/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.github.devcyntrix.deathchest.util.FilterType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record WorldFilterConfig(FilterType filterType, Set<String> worlds) implements Predicate<World>
{
    public static final FilterType DEFAULT_TYPE = FilterType.BLACKLIST;

    @Contract(value="null -> new")
    @NotNull
    public static WorldFilterConfig load(@Nullable ConfigurationSection section) {
        if (section == null) {
            return new WorldFilterConfig(DEFAULT_TYPE, Collections.emptySet());
        }
        String filterString = section.getString("filter");
        if (filterString != null) {
            try {
                FilterType filterType = FilterType.valueOf(filterString.toUpperCase());
                List worlds = section.getStringList("worlds");
                return new WorldFilterConfig(filterType, new HashSet<String>(worlds));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unknown world filter in DeathChest/config.yml");
                e.printStackTrace();
            }
        }
        return new WorldFilterConfig(DEFAULT_TYPE, Collections.emptySet());
    }

    @Override
    public boolean test(World world) {
        return this.filterType() == FilterType.WHITELIST && this.worlds().contains(world.getName()) || this.filterType() == FilterType.BLACKLIST && !this.worlds().contains(world.getName());
    }
}

