/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record WorldAliasConfig(Map<String, Object> aliases) {
    @Contract(value="null -> new")
    @NotNull
    public static WorldAliasConfig load(ConfigurationSection section) {
        if (section == null) {
            return new WorldAliasConfig(Map.of());
        }
        Map aliases = section.getValues(false);
        if (aliases.isEmpty()) {
            return new WorldAliasConfig(Map.of());
        }
        return new WorldAliasConfig(Map.copyOf(aliases));
    }

    @NotNull
    public String getAlias(@NotNull String worldName) {
        return (String)this.aliases.getOrDefault(worldName, worldName);
    }
}

