/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.google.gson.annotations.SerializedName;
import java.time.Duration;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ThiefProtectionOptions(@SerializedName(value="enabled") boolean enabled, @SerializedName(value="permission") String permission, @SerializedName(value="bypass-permission") String bypassPermission, @SerializedName(value="expiration") @NotNull Duration expiration, @SerializedName(value="sound") Sound sound, @SerializedName(value="volume") float volume, @SerializedName(value="pitch") float pitch, @SerializedName(value="message") String[] message) {
    public static final String DEFAULT_PERMISSION = "deathchest.thiefprotected";
    public static final String DEFAULT_BYPASS_PERMISSION = "deathchest.thiefprotected.bypass";
    public static final Duration DEFAULT_DURATION = Duration.ofSeconds(0L);

    @Contract(value="null -> new")
    @NotNull
    public static ThiefProtectionOptions load(@Nullable ConfigurationSection section) {
        if (section == null) {
            return new ThiefProtectionOptions(false, DEFAULT_PERMISSION, DEFAULT_BYPASS_PERMISSION, DEFAULT_DURATION, null, 1.0f, 1.0f, null);
        }
        boolean enabled = section.getBoolean("enabled", false);
        String permission = section.getString("permission", DEFAULT_PERMISSION);
        String bypassPermission = section.getString("bypass-permission", DEFAULT_BYPASS_PERMISSION);
        long expirationInSeconds = section.getLong("expiration", 0L);
        Duration expiration = Duration.ofSeconds(Math.max(expirationInSeconds, 0L));
        String soundString = section.getString("sound");
        Sound sound = null;
        float volume = 1.0f;
        float pitch = 1.0f;
        if (soundString != null) {
            String[] soundArray = soundString.split(";", 3);
            sound = Sound.valueOf((String)soundArray[0].toUpperCase());
            volume = Float.parseFloat(soundArray[1]);
            pitch = Float.parseFloat(soundArray[2]);
        }
        String message = section.getString("message");
        String[] messageArray = null;
        if (message != null) {
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            messageArray = message.split(System.lineSeparator());
        }
        return new ThiefProtectionOptions(enabled, permission, bypassPermission, expiration, sound, volume, pitch, messageArray);
    }

    public void playSound(Player player, Location location) {
        if (this.sound == null) {
            return;
        }
        player.playSound(location, this.sound, this.volume, this.pitch);
    }

    public void notify(Player player) {
        if (this.message == null) {
            return;
        }
        player.sendMessage(this.message);
    }
}

