/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.controller.PlaceholderController;
import com.google.gson.annotations.SerializedName;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerNotificationOptions(@SerializedName(value="enabled") boolean enabled, @SerializedName(value="messages") String[] message) {
    @Contract(value="null -> new")
    @NotNull
    public static PlayerNotificationOptions load(@Nullable ConfigurationSection section) {
        if (section == null) {
            return new PlayerNotificationOptions(false, null);
        }
        boolean enabled = section.getBoolean("enabled", false);
        String message = section.getString("message");
        String[] coloredMessage = null;
        if (message != null) {
            TextComponent deserialize = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
            String serialize = ((String)MiniMessage.miniMessage().serialize((Component)deserialize)).replace("\\", "");
            coloredMessage = serialize.split("\n");
        }
        return new PlayerNotificationOptions(enabled, coloredMessage);
    }

    public void showNotification(Audience audience, DeathChestModel model, PlaceholderController controller) {
        for (String message : this.message()) {
            message = controller.replace(model, message);
            Component deserialize = MiniMessage.miniMessage().deserialize((Object)message);
            audience.sendMessage(deserialize);
        }
    }
}

