/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.google.gson.annotations.SerializedName;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ParticleOptions(@SerializedName(value="enabled") boolean enabled, @SerializedName(value="radius") double radius, @SerializedName(value="count") int count, @SerializedName(value="speed") double speed) {
    public static final double DEFAULT_RADIUS = 1.0;
    public static final int DEFAULT_COUNT = 32;
    public static final double DEFAULT_SPEED = 20.0;

    @Contract(value="null -> new")
    @NotNull
    public static ParticleOptions load(@Nullable ConfigurationSection section) {
        if (section == null) {
            return new ParticleOptions(false, 1.0, 32, 20.0);
        }
        boolean enabled = section.getBoolean("enabled", true);
        double radius = section.getDouble("radius", 1.0);
        int count = section.getInt("count", 32);
        double speed = section.getDouble("speed", 20.0);
        return new ParticleOptions(enabled, radius, count, speed);
    }
}

