/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.google.gson.annotations.SerializedName;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record InventoryOptions(@SerializedName(value="title") @NotNull String title, @SerializedName(value="size") @NotNull InventorySize size) {
    public static final String DEFAULT_TITLE = "Death Chest";
    public static final InventorySize DEFAULT_SIZE = InventorySize.FLEXIBLE;

    public Inventory createInventory(DeathChestModel model, Function<String, String> placeholder, ItemStack ... stacks) {
        String title = placeholder.apply(this.title());
        Inventory inventory = Bukkit.createInventory((InventoryHolder)model, (int)this.size().getSize(stacks.length), (String)title);
        inventory.setContents(stacks);
        return inventory;
    }

    @Contract(value="null -> new")
    @NotNull
    public static InventoryOptions load(@Nullable ConfigurationSection section) {
        if (section == null) {
            section = new MemoryConfiguration();
        }
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("title", DEFAULT_TITLE));
        String sizeString = section.getString("size", DEFAULT_SIZE.name().toLowerCase());
        InventorySize size = InventorySize.valueOf(sizeString.toUpperCase());
        return new InventoryOptions(title, size);
    }

    public static enum InventorySize {
        CONSTANT(integer -> 45),
        FLEXIBLE(integer -> {
            double rel = (double)integer.intValue() / 9.0;
            int round = (int)Math.ceil(rel);
            return 9 * round;
        });

        private final Function<Integer, Integer> sizeFunction;

        private InventorySize(Function<Integer, Integer> sizeFunction) {
            this.sizeFunction = sizeFunction;
        }

        public int getSize(int itemCount) {
            return this.sizeFunction.apply(itemCount);
        }
    }
}

