/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record HologramOptions(@SerializedName(value="enabled") boolean enabled, @SerializedName(value="height") double height, @SerializedName(value="line-height") double lineHeight, @SerializedName(value="lines") Collection<String> lines) {
    public static final double DEFAULT_HEIGHT = 1.0;
    public static final double DEFAULT_LINE_HEIGHT = 0.25;

    @Contract(value="null -> new")
    @NotNull
    public static HologramOptions load(ConfigurationSection section) {
        if (section == null) {
            return new HologramOptions(false, 1.0, 0.25, null);
        }
        boolean enabled = section.getBoolean("enabled", true);
        double height = section.getDouble("height", 1.0);
        double lineHeight = section.getDouble("line-height", 0.25);
        List<String> lines = section.getList("lines", Arrays.asList("&7&lR.I.P", "${player_name}", "&3-&6-&3-&6-&3-&6-&3-", "${duration}")).stream().map(Object::toString).map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).toList();
        return new HologramOptions(enabled, height, lineHeight, lines);
    }
}

