/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.controller.PlaceholderController;
import com.google.gson.annotations.SerializedName;
import java.util.Optional;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GlobalNotificationOptions(@SerializedName(value="enabled") boolean enabled, @SerializedName(value="exclude-died-player") boolean excludeDiedPlayer, @SerializedName(value="message") String[] message) {
    @NotNull
    public static GlobalNotificationOptions load(@Nullable ConfigurationSection section) {
        if (section == null) {
            return new GlobalNotificationOptions(false, false, null);
        }
        boolean enabled = section.getBoolean("enabled", false);
        boolean excludeDiedPlayer = section.getBoolean("exclude-died-player", false);
        String message = section.getString("message");
        String[] coloredMessage = null;
        if (message != null) {
            TextComponent deserialize = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
            String serialize = ((String)MiniMessage.miniMessage().serialize((Component)deserialize)).replace("\\", "");
            coloredMessage = serialize.split("\n");
        }
        return new GlobalNotificationOptions(enabled, excludeDiedPlayer, coloredMessage);
    }

    public void showNotification(DeathChestModel model, Player diedPlayer, PlaceholderController controller) {
        for (String message : this.message()) {
            message = controller.replace(model, message);
            Component deserialize = MiniMessage.miniMessage().deserialize((Object)message);
            ((DeathChestPlugin)JavaPlugin.getPlugin(DeathChestPlugin.class)).getAudiences().all().filterAudience(audience -> {
                Optional uuid = audience.get(Identity.UUID);
                if (!this.excludeDiedPlayer) {
                    return true;
                }
                return !diedPlayer.getUniqueId().equals(uuid.orElse(null));
            }).sendMessage(deserialize);
        }
    }
}

