/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.github.devcyntrix.deathchest.config.BreakAnimationOptions;
import com.github.devcyntrix.deathchest.config.ChangeDeathMessageOptions;
import com.github.devcyntrix.deathchest.config.ChestOptions;
import com.github.devcyntrix.deathchest.config.GlobalNotificationOptions;
import com.github.devcyntrix.deathchest.config.HologramOptions;
import com.github.devcyntrix.deathchest.config.InventoryOptions;
import com.github.devcyntrix.deathchest.config.ParticleOptions;
import com.github.devcyntrix.deathchest.config.PlayerNotificationOptions;
import com.github.devcyntrix.deathchest.config.WorldAliasConfig;
import com.github.devcyntrix.deathchest.config.WorldFilterConfig;
import com.google.gson.annotations.SerializedName;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DeathChestConfig(@SerializedName(value="config-version") int configVersion, @SerializedName(value="debug") boolean debug, @SerializedName(value="update-checker") boolean updateChecker, @SerializedName(value="auto-update") boolean autoUpdate, @SerializedName(value="duration-format") @NotNull String durationFormat, @SerializedName(value="chest") @NotNull ChestOptions chestOptions, @SerializedName(value="inventory") @NotNull InventoryOptions inventoryOptions, @SerializedName(value="hologram") @NotNull HologramOptions hologramOptions, @SerializedName(value="particle") @NotNull ParticleOptions particleOptions, @SerializedName(value="break-effect") @NotNull BreakAnimationOptions breakAnimationOptions, @SerializedName(value="player-notification") @NotNull PlayerNotificationOptions playerNotificationOptions, @SerializedName(value="global-notification") @NotNull GlobalNotificationOptions globalNotificationOptions, @SerializedName(value="change-death-message") @NotNull ChangeDeathMessageOptions changeDeathMessageOptions, @SerializedName(value="world-filter") @NotNull WorldFilterConfig worldFilterConfig, @SerializedName(value="world-chest-protection-filter") @NotNull WorldFilterConfig worldChestProtectionFilter, @SerializedName(value="world-alias") @NotNull WorldAliasConfig worldAlias, @SerializedName(value="preferred-animation-service") @Nullable String preferredBlockBreakAnimationService) {
    public static final int CONFIG_VERSION = 3;

    public static DeathChestConfig load(FileConfiguration config) {
        int configVersion = config.getInt("config-version");
        boolean debug = config.getBoolean("debug", false);
        boolean updateCheck = config.getBoolean("update-checker", true);
        boolean autoUpdate = config.getBoolean("auto-update", true);
        String durationFormat = config.getString("duration-format", "mm:ss");
        ChestOptions chestOptions = ChestOptions.load(config.getConfigurationSection("chest"));
        InventoryOptions inventoryOptions = InventoryOptions.load(config.getConfigurationSection("inventory"));
        HologramOptions hologramOptions = HologramOptions.load(config.getConfigurationSection("hologram"));
        ParticleOptions particleOptions = ParticleOptions.load(config.getConfigurationSection("particle"));
        BreakAnimationOptions breakAnimationOptions = BreakAnimationOptions.load(config.getConfigurationSection("break-effect"));
        PlayerNotificationOptions playerNotificationOptions = PlayerNotificationOptions.load(config.getConfigurationSection("player-notification"));
        GlobalNotificationOptions globalNotificationOptions = GlobalNotificationOptions.load(config.getConfigurationSection("global-notification"));
        ChangeDeathMessageOptions changeDeathMessageOptions = ChangeDeathMessageOptions.load(config.getConfigurationSection("change-death-message"));
        WorldFilterConfig worldFilterConfig = WorldFilterConfig.load(config.getConfigurationSection("world-filter"));
        WorldFilterConfig worldChestProtectionFilterConfig = WorldFilterConfig.load(config.getConfigurationSection("world-chest-protection-filter"));
        WorldAliasConfig worldAliasConfig = WorldAliasConfig.load(config.getConfigurationSection("world-alias"));
        String preferredAnimationService = config.getString("preferred-animation-service");
        return new DeathChestConfig(configVersion, debug, updateCheck, autoUpdate, durationFormat, chestOptions, inventoryOptions, hologramOptions, particleOptions, breakAnimationOptions, playerNotificationOptions, globalNotificationOptions, changeDeathMessageOptions, worldFilterConfig, worldChestProtectionFilterConfig, worldAliasConfig, preferredAnimationService);
    }
}

