/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.github.devcyntrix.deathchest.config.NoExpirationPermission;
import com.github.devcyntrix.deathchest.config.ThiefProtectionOptions;
import com.google.gson.annotations.SerializedName;
import java.time.Duration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ChestOptions(@SerializedName(value="expiration") @Nullable Duration expiration, @SerializedName(value="no-expiration-permission") @NotNull NoExpirationPermission noExpirationPermission, @SerializedName(value="drop-items-after-expiration") boolean dropItemsAfterExpiration, @SerializedName(value="blast-protection") boolean blastProtection, @SerializedName(value="thief-protection") @NotNull ThiefProtectionOptions thiefProtectionOptions) {
    @Contract(value="null -> new")
    @NotNull
    public static ChestOptions load(@Nullable ConfigurationSection section) {
        long expirationInSeconds;
        if (section == null) {
            section = new MemoryConfiguration();
        }
        Duration expiration = null;
        if (section.contains("expiration") && (expirationInSeconds = section.getLong("expiration")) > 0L) {
            expiration = Duration.ofSeconds(expirationInSeconds);
        }
        NoExpirationPermission noExpirationPermission = NoExpirationPermission.load(section.getConfigurationSection("no-expiration-permission"));
        boolean dropItemsAfterExpiration = section.getBoolean("drop-items-after-expiration", false);
        boolean blastProtection = section.getBoolean("blast-protection", false);
        ThiefProtectionOptions thiefProtectionOptions = ThiefProtectionOptions.load(section.getConfigurationSection("thief-protection"));
        return new ChestOptions(expiration, noExpirationPermission, dropItemsAfterExpiration, blastProtection, thiefProtectionOptions);
    }
}

