/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.config;

import com.google.gson.annotations.SerializedName;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BreakAnimationOptions(@SerializedName(value="enabled") boolean enabled, @SerializedName(value="view-distance") double viewDistance) {
    public static final double DEFAULT_VIEW_DISTANCE = 20.0;

    @Contract(value="null -> new")
    @NotNull
    public static BreakAnimationOptions load(@Nullable ConfigurationSection section) {
        if (section == null) {
            return new BreakAnimationOptions(false, 20.0);
        }
        boolean enabled = section.getBoolean("enabled", true);
        double viewDistance = section.getDouble("view-distance", 20.0);
        return new BreakAnimationOptions(enabled, viewDistance);
    }
}

