/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.command.admin.argument;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.captions.Caption;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.google.gson.internal.bind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DateArgument<C>
extends CommandArgument<C, Date> {
    protected DateArgument(DeathChestPlugin deathChestPlugin, boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new DateParser(deathChestPlugin), defaultValue, Date.class, suggestionsProvider, defaultDescription);
    }

    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandArgument.Builder<C, Date> newBuilder(DeathChestPlugin deathChestPlugin, @NonNull String name) {
        return new Builder(deathChestPlugin, name);
    }

    public static <C> @NonNull CommandArgument<C, Date> of(DeathChestPlugin deathChestPlugin, @NonNull String name) {
        return DateArgument.newBuilder(deathChestPlugin, name).asRequired().build();
    }

    public static final class DateParser<C>
    implements ArgumentParser<C, Date> {
        private final DeathChestPlugin deathChestPlugin;

        DateParser(DeathChestPlugin deathChestPlugin) {
            this.deathChestPlugin = deathChestPlugin;
        }

        public @NonNull ArgumentParseResult<@NonNull Date> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            Date date;
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(DateParser.class, commandContext));
            }
            try {
                date = ISO8601Utils.parse((String)input, (ParsePosition)new ParsePosition(0));
            }
            catch (ParseException e) {
                return ArgumentParseResult.failure((Throwable)((Object)new DateParseException(input, commandContext)));
            }
            inputQueue.remove();
            return ArgumentParseResult.success((Object)date);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return (List)StringUtil.copyPartialMatches((String)input, this.deathChestPlugin.getReportManager().getReportDates().stream().map(ISO8601Utils::format).toList(), new ArrayList());
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Date> {
        private final DeathChestPlugin deathChestPlugin;

        private Builder(DeathChestPlugin deathChestPlugin, @NonNull String name) {
            super(Date.class, name);
            this.deathChestPlugin = deathChestPlugin;
        }

        public @NonNull CommandArgument<C, Date> build() {
            return new DateArgument(this.deathChestPlugin, this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class DateParseException
    extends ParserException {
        private final String input;

        public DateParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(DateParser.class, context, Caption.of((String)"argument.parse.failure.date"), new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

