/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.blacklist;

import com.github.devcyntrix.api.event.InventoryChangeSlotItemEvent;
import com.github.devcyntrix.deathchest.blacklist.ItemBlacklist;
import java.util.List;
import java.util.Objects;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemBlacklistListener
implements Listener {
    private final ItemBlacklist blacklist;

    public ItemBlacklistListener(ItemBlacklist blacklist) {
        this.blacklist = blacklist;
    }

    @EventHandler
    public void onUpdateItem(InventoryChangeSlotItemEvent event) {
        if (!Objects.equals(event.getInventory().getHolder(), this.blacklist)) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == 49) {
            this.updateApplyItem(event.getInventory(), event.getTo());
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!Objects.equals(this.blacklist, event.getClickedInventory().getHolder())) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() < 45) {
            if (event.isRightClick()) {
                this.blacklist.getList().removeIf(itemStack -> itemStack.isSimilar(event.getCurrentItem()));
                this.blacklist.updateInventory();
                return;
            }
        } else {
            if (event.getSlot() == 53 && ItemBlacklist.NEXT_PAGE.isSimilar(event.getCurrentItem())) {
                this.blacklist.setPage(this.blacklist.getPage() + 1);
                this.blacklist.updateInventory();
                return;
            }
            if (event.getSlot() == 45 && ItemBlacklist.PREV_PAGE.isSimilar(event.getCurrentItem())) {
                this.blacklist.setPage(this.blacklist.getPage() - 1);
                this.blacklist.updateInventory();
                return;
            }
            if (event.getSlot() == 51) {
                ItemStack itemToAdd = event.getInventory().getItem(49);
                if (!this.blacklist.isValidItem(itemToAdd)) {
                    HumanEntity humanEntity = event.getWhoClicked();
                    if (humanEntity instanceof Player) {
                        Player player = (Player)humanEntity;
                        player.playNote(player.getLocation(), Instrument.BASS_DRUM, Note.flat((int)1, (Note.Tone)Note.Tone.D));
                    }
                    return;
                }
                if (ItemBlacklist.ADD_ITEM.isSimilar(event.getCurrentItem())) {
                    this.blacklist.getList().add(itemToAdd);
                    this.blacklist.updateInventory();
                    event.getInventory().clear(49);
                    this.updateApplyItem(event.getInventory(), null);
                    return;
                }
                if (ItemBlacklist.FORCE_ADD_ITEM.isSimilar(event.getCurrentItem())) {
                    List<ItemStack> list = this.blacklist.getList().stream().filter(stack -> !this.blacklist.compareItem(itemToAdd, (ItemStack)stack)).toList();
                    this.blacklist.getList().clear();
                    this.blacklist.getList().addAll(list);
                    event.getInventory().clear(49);
                    this.blacklist.getList().add(itemToAdd);
                    this.blacklist.updateInventory();
                    this.updateApplyItem(event.getInventory(), null);
                    return;
                }
            }
        }
    }

    private boolean hasDuplicate(ItemStack stack) {
        return stack != null && !stack.getType().isAir() && this.blacklist.getList().stream().anyMatch(stack1 -> this.blacklist.compareItem(stack, (ItemStack)stack1));
    }

    private void updateApplyItem(Inventory inventory, ItemStack clicked) {
        ItemStack stack = ItemBlacklist.DENY_ITEM;
        if (this.blacklist.isValidItem(clicked)) {
            stack = ItemBlacklist.ADD_ITEM;
            if (this.hasDuplicate(clicked)) {
                stack = ItemBlacklist.FORCE_ADD_ITEM;
            }
        }
        inventory.setItem(51, stack);
    }
}

