/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.blacklist;

import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ItemBlacklist
implements InventoryHolder {
    public static final ItemStack ADD_ITEM = new ItemStack(Material.EMERALD_BLOCK);
    public static final ItemStack FORCE_ADD_ITEM = new ItemStack(Material.LAPIS_BLOCK);
    public static final ItemStack DENY_ITEM = new ItemStack(Material.RED_STAINED_GLASS_PANE);
    public static final ItemStack NEXT_PAGE = new ItemStack(Material.ARROW);
    public static final ItemStack PREV_PAGE = new ItemStack(Material.ARROW);
    private final File file;
    private final Set<ItemStack> list = new HashSet<ItemStack>();
    private final Inventory inventory;
    private int page;

    public ItemBlacklist(File file) {
        this.file = file;
        if (file.isFile()) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            this.list.addAll(yamlConfiguration.getList("blacklist", new ArrayList()));
        }
        this.list.removeIf(Objects::isNull);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)"Blacklist");
        this.inventory.setMaxStackSize(1);
        this.updateInventory();
    }

    private void renderBackground() {
        ItemStack stack = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta itemMeta = stack.getItemMeta();
        itemMeta.setDisplayName("\u00a7r");
        stack.setItemMeta(itemMeta);
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, stack);
        }
    }

    public boolean isValidItem(ItemStack stack) {
        return stack != null && !stack.getType().isAir() && this.getList().stream().noneMatch(stack1 -> this.compareItem((ItemStack)stack1, stack));
    }

    public boolean compareItem(ItemStack higher, ItemStack lower) {
        boolean result = Objects.equals(higher.getType(), lower.getType());
        if (!result) {
            return false;
        }
        boolean bl = result = higher.getItemMeta() == null || lower.getItemMeta() != null;
        if (higher.getItemMeta() != null && result) {
            ItemMeta meta = higher.getItemMeta();
            boolean bl2 = result = !higher.getItemMeta().hasDisplayName() || lower.getItemMeta().hasDisplayName();
            if (meta.hasDisplayName() && result) {
                result = Objects.equals(meta.getDisplayName(), lower.getItemMeta().getDisplayName());
            }
            boolean bl3 = result = result && !higher.getItemMeta().hasLore() || lower.getItemMeta().hasLore();
            if (meta.hasLore() && result) {
                result = Objects.equals(meta.getLore(), lower.getItemMeta().getLore());
            }
            boolean bl4 = result = result && !higher.getItemMeta().hasCustomModelData() || lower.getItemMeta().hasCustomModelData();
            if (meta.hasCustomModelData() && result) {
                result = Objects.equals(meta.getCustomModelData(), lower.getItemMeta().getCustomModelData());
            }
            boolean bl5 = result = result && !higher.getItemMeta().hasAttributeModifiers() || lower.getItemMeta().hasAttributeModifiers();
            if (meta.hasAttributeModifiers() && result) {
                result = Objects.equals(meta.getAttributeModifiers(), lower.getItemMeta().getAttributeModifiers());
            }
            result = result && !higher.getItemMeta().isUnbreakable() || lower.getItemMeta().isUnbreakable();
        }
        return result;
    }

    public void updateInventory() {
        this.renderBackground();
        this.inventory.clear(this.inventory.getSize() - 5);
        this.inventory.setItem(this.inventory.getSize() - 3, DENY_ITEM);
        this.list.stream().filter(Objects::nonNull).forEach(stack -> stack.setAmount(1));
        AtomicInteger i = new AtomicInteger();
        this.list.stream().skip(((long)this.inventory.getSize() - 9L) * (long)this.page).limit((long)this.inventory.getSize() - 9L).forEach(stack -> this.inventory.setItem(i.getAndIncrement(), stack));
        if (this.getList().size() > 46 * (this.page + 1)) {
            this.getInventory().setItem(53, NEXT_PAGE);
        }
        if (this.page > 0) {
            this.getInventory().setItem(45, PREV_PAGE);
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void save() throws IOException {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("blacklist", this.list.stream().toList());
        configuration.save(this.file);
    }

    public Set<ItemStack> getList() {
        return this.list;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    static {
        ItemMeta itemMeta = ADD_ITEM.getItemMeta();
        itemMeta.setDisplayName("\u00a7rAdd item");
        ADD_ITEM.setItemMeta(itemMeta);
        itemMeta = FORCE_ADD_ITEM.getItemMeta();
        itemMeta.setDisplayName("\u00a7rForce add item");
        itemMeta.setLore(Arrays.asList("\u00a77This will remove all items from the blacklist which falls into the scheme."));
        FORCE_ADD_ITEM.setItemMeta(itemMeta);
        itemMeta = DENY_ITEM.getItemMeta();
        itemMeta.setDisplayName("\u00a7cItem not found");
        DENY_ITEM.setItemMeta(itemMeta);
        itemMeta = NEXT_PAGE.getItemMeta();
        itemMeta.setDisplayName("\u00a77Next page");
        NEXT_PAGE.setItemMeta(itemMeta);
        itemMeta = PREV_PAGE.getItemMeta();
        itemMeta.setDisplayName("\u00a77Previous page");
        PREV_PAGE.setItemMeta(itemMeta);
    }
}

