/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.audit;

import com.github.devcyntrix.deathchest.api.audit.AuditItem;
import com.github.devcyntrix.deathchest.api.audit.AuditManager;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@Singleton
public class GsonAuditManager
extends Thread
implements AuditManager {
    private static final String format = "audit-%s.csv";
    private final File folder;
    private final BlockingQueue<AuditItem> items = new LinkedBlockingQueue<AuditItem>();

    public GsonAuditManager(File folder) {
        this.folder = folder;
        if (!this.folder.isDirectory() && !this.folder.mkdirs()) {
            throw new RuntimeException("Cannot create audit folder \"%s\"".formatted(folder));
        }
        this.start();
    }

    @Override
    public void audit(AuditItem item) {
        boolean offer = this.items.offer(item);
        if (!offer) {
            throw new IllegalStateException("Cannot offer audit item to the queue " + String.valueOf(item));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                AuditItem item = this.items.take();
                File file = new File(this.folder, format.formatted(DATE_FORMAT.format(item.date())));
                try (FileWriter writer = new FileWriter(file, true);){
                    writer.write(String.valueOf(item) + "\n");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.interrupt();
    }
}

