/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.api.report;

import com.github.devcyntrix.deathchest.api.report.Report;
import com.google.gson.internal.bind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ReportManager {
    public static final int DATE_FORMAT_CONFIG = 2;

    default public void createReport() {
        this.addReport(Report.create());
    }

    public void addReport(@NotNull Report var1);

    @Nullable
    public Report getLatestReport();

    @NotNull
    public @NotNull Set<@NotNull Report> getReports();

    @NotNull
    public TreeSet<Date> getReportDates();

    default public boolean deleteReport(@NotNull Report report) {
        return this.deleteReport(report.date());
    }

    public boolean deleteReport(@NotNull Date var1);

    public void deleteReports();

    @Nullable
    public static Date parseISO(@NotNull String value) {
        try {
            return ISO8601Utils.parse((String)value, (ParsePosition)new ParsePosition(0));
        }
        catch (ParseException e) {
            return null;
        }
    }

    @NotNull
    public static String formatISO(@NotNull Date date) {
        return ISO8601Utils.format((Date)date);
    }
}

