/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.api.report;

import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.report.PluginInfo;
import com.github.devcyntrix.deathchest.config.DeathChestConfig;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public record Report(@SerializedName(value="date") Date date, @SerializedName(value="plugins") Set<PluginInfo> plugins, @SerializedName(value="config") DeathChestConfig config, @SerializedName(value="extra") Map<String, Object> extra) {
    public static Report create() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Set<PluginInfo> collect = Arrays.stream(pluginManager.getPlugins()).map(PluginInfo::of).collect(Collectors.toSet());
        DeathChestPlugin plugin = (DeathChestPlugin)JavaPlugin.getPlugin(DeathChestPlugin.class);
        return new Report(new Date(), collect, plugin.getDeathChestConfig(), new HashMap<String, Object>());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.date, report.date);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.date);
    }
}

