/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.api.compatibility;

import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.compatibility.Compatibility;
import com.github.devcyntrix.deathchest.api.compatibility.CompatibilityLoader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompatibilityManager {
    private final Set<Class<? extends Compatibility>> registeredCompatibilities = new HashSet<Class<? extends Compatibility>>();
    private final Map<Class<? extends Compatibility>, Compatibility> instances = new HashMap<Class<? extends Compatibility>, Compatibility>();
    private final DeathChestPlugin plugin;
    private final CompatibilityLoader loader;

    public boolean registerCompatibility(Class<? extends Compatibility> clazz) {
        return this.registeredCompatibilities.add(clazz);
    }

    public boolean unregisterCompatibility(Class<? extends Compatibility> clazz) {
        if (this.registeredCompatibilities.remove(clazz)) {
            Compatibility compatibility = this.instances.remove(clazz);
            if (compatibility == null) {
                return true;
            }
            if (!compatibility.isEnabled()) {
                return true;
            }
            return compatibility.deactivate(this.plugin);
        }
        return false;
    }

    public void enableCompatibilities() {
        if (!this.instances.isEmpty()) {
            throw new IllegalStateException("Already compatibilities enabled");
        }
        for (Class<? extends Compatibility> rc : this.registeredCompatibilities) {
            try {
                Compatibility load = this.loader.load(rc);
                if (!load.isValid(this.plugin.getServer())) continue;
                if (!load.activate(this.plugin)) {
                    this.plugin.getLogger().severe("Something went wrong while activating " + rc.getSimpleName());
                    continue;
                }
                this.instances.put(rc, load);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.plugin.getLogger().severe("Failed to load " + rc.getSimpleName());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    public void disableCompatibilities() {
        for (Compatibility compatibility : this.instances.values()) {
            if (!compatibility.isEnabled() || compatibility.deactivate(this.plugin)) continue;
            this.plugin.getLogger().severe("Something went wrong while deactivating " + compatibility.getClass().getSimpleName());
        }
    }

    public CompatibilityManager(DeathChestPlugin plugin, CompatibilityLoader loader) {
        this.plugin = plugin;
        this.loader = loader;
    }
}

