/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.api;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.api.animation.BreakAnimationService;
import com.github.devcyntrix.deathchest.api.protection.ProtectionService;
import com.github.devcyntrix.hologram.api.HologramService;
import java.io.IOException;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DeathChestService
extends Plugin {
    public boolean isDebugMode();

    default public void debug(int indents, Object ... message) {
        if (!this.isDebugMode()) {
            return;
        }
        Class<?> callerClass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        for (Object o : message) {
            this.getLogger().info("[DEBUG] [%s] ".formatted(callerClass.getCanonicalName()) + "  ".repeat(indents) + String.valueOf(o));
        }
    }

    @Nullable
    public DeathChestModel getLastChest(@NotNull Player var1);

    public boolean canPlaceChestAt(@NotNull Location var1);

    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location var1, ItemStack ... var2);

    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location var1, @Nullable Player var2, ItemStack ... var3);

    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location var1, long var2, @Nullable Player var4, ItemStack ... var5);

    @NotNull
    default public DeathChestModel createDeathChest(@NotNull Location location, long createdAt, long expireAt, @Nullable Player player, ItemStack ... items) {
        return this.createDeathChest(location, createdAt, expireAt, player, false, items);
    }

    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location var1, long var2, long var4, @Nullable Player var6, boolean var7, ItemStack ... var8);

    @NotNull
    public @NotNull Stream<@NotNull DeathChestModel> getChests();

    @NotNull
    public @NotNull Stream<@NotNull DeathChestModel> getChests(@NotNull World var1);

    public void saveChests() throws IOException;

    default public boolean hasHologram() {
        return this.getHologramService() != null;
    }

    @Nullable
    public HologramService getHologramService();

    default public boolean hasBreakAnimation() {
        return this.getBreakAnimationService() != null;
    }

    @Nullable
    public BreakAnimationService getBreakAnimationService();

    @NotNull
    public ProtectionService getProtectionService();
}

