/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest;

import com.comphenix.protocol.ProtocolLibrary;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.animation.BreakAnimationService;
import com.github.devcyntrix.deathchest.api.protection.ProtectionService;
import com.github.devcyntrix.deathchest.support.animation.PaperBreakAnimation;
import com.github.devcyntrix.deathchest.support.animation.ProtocolLibBreakAnimation;
import com.github.devcyntrix.deathchest.support.protection.CombinedProtectionService;
import com.github.devcyntrix.deathchest.support.protection.GriefPreventionProtection;
import com.github.devcyntrix.deathchest.support.protection.MinePlotsProtection;
import com.github.devcyntrix.deathchest.support.protection.MinecraftProtection;
import com.github.devcyntrix.deathchest.support.protection.PlotSquaredProtection;
import com.github.devcyntrix.deathchest.support.protection.RedProtectProtection;
import com.github.devcyntrix.deathchest.support.protection.WorldGuardProtection;
import com.github.devcyntrix.deathchest.util.PaperTest;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SupportServices {
    private static final Map<String, Function<Plugin, BreakAnimationService>> animationServiceMap = Map.of("ProtocolLib", plugin -> ProtocolLibrary.getProtocolManager() != null ? new ProtocolLibBreakAnimation() : null);
    private static final Map<String, Function<Plugin, ProtectionService>> protectionServiceMap = Map.of("WorldGuard", plugin -> new WorldGuardProtection(), "PlotSquared", plugin -> new PlotSquaredProtection(), "GriefPrevention", plugin -> new GriefPreventionProtection(), "RedProtect", plugin -> new RedProtectProtection(), "minePlots", plugin -> new MinePlotsProtection());

    @Nullable
    public static BreakAnimationService getBlockBreakAnimationService(@NotNull DeathChestPlugin plugin, @Nullable String preferred) {
        if (PaperTest.isPaper()) {
            plugin.debug(1, new Object[]{"Using paper block break animation service"});
            return new PaperBreakAnimation();
        }
        return (BreakAnimationService)SupportServices.getService(animationServiceMap, plugin, preferred);
    }

    @NotNull
    public static ProtectionService getProtectionService(@NotNull DeathChestPlugin plugin) {
        ArrayList<ProtectionService> services = new ArrayList<ProtectionService>();
        services.add(new MinecraftProtection());
        for (Map.Entry<String, Function<Plugin, ProtectionService>> entry : protectionServiceMap.entrySet()) {
            ProtectionService apply;
            if (!Bukkit.getPluginManager().isPluginEnabled(entry.getKey()) || (apply = entry.getValue().apply(plugin)) == null) continue;
            plugin.debug(1, new Object[]{"Using " + entry.getKey() + " protection service"});
            services.add(apply);
        }
        return new CombinedProtectionService((ProtectionService[])services.toArray(ProtectionService[]::new));
    }

    @Nullable
    private static <T> T getService(@NotNull Map<String, Function<Plugin, T>> map, @NotNull Plugin plugin, @Nullable String preferred) {
        if (preferred != null) {
            T service;
            Function<Plugin, Plugin> func;
            if (Bukkit.getPluginManager().isPluginEnabled(preferred) && (func = map.get(preferred)) != null && (service = func.apply(plugin)) != null) {
                return service;
            }
            plugin.getLogger().warning("Cannot use the preferred service \"%s\"".formatted(preferred));
        }
        for (Map.Entry<String, Function<Plugin, T>> entry : map.entrySet()) {
            if (!Bukkit.getPluginManager().isPluginEnabled(entry.getKey())) continue;
            Function<Plugin, Plugin> value = entry.getValue();
            T apply = value.apply(plugin);
            if (apply == null) {
                plugin.getLogger().warning("Failed to initialize the service \"%s\"".formatted(entry.getKey()));
                continue;
            }
            return apply;
        }
        return null;
    }
}

