/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest;

import com.github.devcyntrix.api.event.InventoryChangeSlotItemListener;
import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.SupportServices;
import com.github.devcyntrix.deathchest.api.DeathChestService;
import com.github.devcyntrix.deathchest.api.animation.BreakAnimationService;
import com.github.devcyntrix.deathchest.api.audit.AuditManager;
import com.github.devcyntrix.deathchest.api.compatibility.CompatibilityLoader;
import com.github.devcyntrix.deathchest.api.compatibility.CompatibilityManager;
import com.github.devcyntrix.deathchest.api.protection.ProtectionService;
import com.github.devcyntrix.deathchest.api.report.ReportManager;
import com.github.devcyntrix.deathchest.api.storage.DeathChestStorage;
import com.github.devcyntrix.deathchest.audit.GsonAuditManager;
import com.github.devcyntrix.deathchest.blacklist.ItemBlacklist;
import com.github.devcyntrix.deathchest.blacklist.ItemBlacklistListener;
import com.github.devcyntrix.deathchest.command.CommandRegistry;
import com.github.devcyntrix.deathchest.config.BreakAnimationOptions;
import com.github.devcyntrix.deathchest.config.DeathChestConfig;
import com.github.devcyntrix.deathchest.config.HologramOptions;
import com.github.devcyntrix.deathchest.config.ParticleOptions;
import com.github.devcyntrix.deathchest.config.ThiefProtectionOptions;
import com.github.devcyntrix.deathchest.controller.DeathChestController;
import com.github.devcyntrix.deathchest.controller.HologramController;
import com.github.devcyntrix.deathchest.controller.LastSafeLocationController;
import com.github.devcyntrix.deathchest.controller.PlaceholderController;
import com.github.devcyntrix.deathchest.controller.UpdateController;
import com.github.devcyntrix.deathchest.listener.ChestDestroyListener;
import com.github.devcyntrix.deathchest.listener.ChestInteractionListener;
import com.github.devcyntrix.deathchest.listener.GlobalNotificationListener;
import com.github.devcyntrix.deathchest.listener.LastDeathChestListener;
import com.github.devcyntrix.deathchest.listener.LastSafeLocationListener;
import com.github.devcyntrix.deathchest.listener.PlayerNotificationListener;
import com.github.devcyntrix.deathchest.listener.SpawnChestListener;
import com.github.devcyntrix.deathchest.listener.WorldListener;
import com.github.devcyntrix.deathchest.metrics.bukkit.Metrics;
import com.github.devcyntrix.deathchest.report.GsonReportManager;
import com.github.devcyntrix.deathchest.support.lock.LWCCompatibility;
import com.github.devcyntrix.deathchest.support.lock.LocketteXCompatibility;
import com.github.devcyntrix.deathchest.support.placeholder.PlaceholderAPICompatibility;
import com.github.devcyntrix.deathchest.support.protection.WorldGuardDeathChestFlag;
import com.github.devcyntrix.deathchest.support.storage.MemoryStorage;
import com.github.devcyntrix.deathchest.support.storage.YamlStorage;
import com.github.devcyntrix.deathchest.util.adapter.DurationAdapter;
import com.github.devcyntrix.deathchest.view.chest.BlockView;
import com.github.devcyntrix.deathchest.view.chest.BreakAnimationView;
import com.github.devcyntrix.deathchest.view.chest.CloseInventoryView;
import com.github.devcyntrix.deathchest.view.chest.ExpirationView;
import com.github.devcyntrix.deathchest.view.chest.HologramView;
import com.github.devcyntrix.deathchest.view.chest.ParticleView;
import com.github.devcyntrix.deathchest.view.update.AdminJoinNotificationView;
import com.github.devcyntrix.deathchest.view.update.AdminNotificationView;
import com.github.devcyntrix.deathchest.view.update.ConsoleNotificationView;
import com.github.devcyntrix.hologram.api.HologramService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class DeathChestPlugin
extends JavaPlugin
implements DeathChestService {
    public static final int RESOURCE_ID = 101066;
    public static final int BSTATS_ID = 14866;
    private DeathChestConfig deathChestConfig;
    private BreakAnimationService breakAnimationService;
    private ProtectionService protectionService;
    private static boolean placeholderAPIEnabled;
    private ReportManager reportManager;
    private AuditManager auditManager;
    private ItemBlacklist blacklist;
    private final Map<Player, DeathChestModel> lastDeathChests = new WeakHashMap<Player, DeathChestModel>();
    @Nullable
    private UpdateController updateController;
    private PlaceholderController placeHolderController;
    private HologramController hologramController;
    private DeathChestStorage deathChestStorage;
    private DeathChestController deathChestController;
    private LastSafeLocationController lastSafeLocationController;
    private BukkitAudiences audiences;
    private CompatibilityManager compatibilityManager;
    private final boolean test;

    public DeathChestPlugin(Boolean test, DeathChestConfig config) {
        this.test = test;
        this.deathChestConfig = config;
    }

    public DeathChestPlugin() {
        this.test = false;
    }

    public void onDisable() {
        if (this.blacklist != null) {
            try {
                this.blacklist.save();
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Failed to save the item black list", e);
            }
            this.blacklist = null;
        }
        PluginManager pluginManager = Bukkit.getPluginManager();
        try {
            ThiefProtectionOptions protectionOptions = this.getDeathChestConfig().chestOptions().thiefProtectionOptions();
            if (protectionOptions.enabled()) {
                this.debug(0, new Object[]{"Disabling chest protection..."});
                this.debug(1, new Object[]{"Removing permissions..."});
                if (pluginManager.getPermission(protectionOptions.permission()) != null) {
                    pluginManager.removePermission(protectionOptions.permission());
                    this.debug(2, new Object[]{"Permission \"%s\" removed.".formatted(protectionOptions.permission())});
                } else {
                    this.getLogger().warning("Expected configured permission but the permission \"%s\" wasn't registered.".formatted(protectionOptions.permission()));
                }
                if (pluginManager.getPermission(protectionOptions.bypassPermission()) != null) {
                    pluginManager.removePermission(protectionOptions.bypassPermission());
                    this.debug(2, new Object[]{"Permission \"%s\" removed.".formatted(protectionOptions.bypassPermission())});
                } else {
                    this.getLogger().warning("Expected configured permission but the permission \"%s\" wasn't registered.".formatted(protectionOptions.bypassPermission()));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to remove the permission of the chest-protection", e);
        }
        if (this.updateController != null) {
            this.updateController.close();
            this.updateController = null;
        }
        ServicesManager servicesManager = this.getServer().getServicesManager();
        this.debug(0, new Object[]{"Removing death chest service..."});
        servicesManager.unregisterAll((Plugin)this);
        if (this.hologramController != null) {
            this.hologramController.close();
            this.hologramController = null;
        }
        if (this.deathChestController != null) {
            try {
                this.deathChestController.close();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to close the death chest controller", e);
            }
            this.deathChestController = null;
        }
        if (this.deathChestStorage != null) {
            try {
                this.deathChestStorage.close();
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Failed to close the death chest storage", e);
            }
            this.deathChestStorage = null;
        }
        if (this.auditManager != null) {
            try {
                this.auditManager.close();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Failed to close the audit manager", e);
            }
            this.auditManager = null;
        }
        if (this.compatibilityManager != null) {
            this.compatibilityManager.disableCompatibilities();
        }
        if (this.audiences != null) {
            this.audiences.close();
        }
        HandlerList.unregisterAll((Plugin)this);
    }

    public void onLoad() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Plugin plugin = pluginManager.getPlugin("WorldGuard");
        if (plugin != null) {
            this.debug(0, new Object[]{"Registering death chest flag to WorldGuard..."});
            WorldGuardDeathChestFlag.register();
        }
        ServicesManager servicesManager = this.getServer().getServicesManager();
        this.debug(0, new Object[]{"Registering death chest service..."});
        servicesManager.register(DeathChestService.class, (Object)this, (Plugin)this, ServicePriority.Normal);
    }

    public void onEnable() {
        this.debug(0, new Object[]{"Loading configuration file..."});
        if (!this.isTest()) {
            this.reloadConfig();
        }
        this.initializeServices();
        this.debug(0, new Object[]{"Registering commands..."});
        CommandRegistry.create(this).registerCommands(this);
        if (!this.test) {
            this.debug(0, new Object[]{"Starting metrics..."});
            new Metrics(this, 14866);
        }
    }

    private void initializeServices() {
        placeholderAPIEnabled = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.debug(0, new Object[]{"Creating hologram controller..."});
        this.hologramController = new HologramController(this);
        this.debug(0, new Object[]{"Selecting animation service..."});
        this.breakAnimationService = SupportServices.getBlockBreakAnimationService(this, this.deathChestConfig.preferredBlockBreakAnimationService());
        this.debug(0, new Object[]{"Selecting protection services..."});
        this.protectionService = SupportServices.getProtectionService(this);
        PluginManager pluginManager = this.getServer().getPluginManager();
        try {
            ThiefProtectionOptions protectionOptions = this.getDeathChestConfig().chestOptions().thiefProtectionOptions();
            if (protectionOptions.enabled()) {
                this.debug(0, new Object[]{"Configuring chest protection..."});
                this.debug(1, new Object[]{"Registering permissions..."});
                if (pluginManager.getPermission(protectionOptions.permission()) == null) {
                    pluginManager.addPermission(new Permission(protectionOptions.permission()));
                    this.debug(2, new Object[]{"Permission \"%s\" registered.".formatted(protectionOptions.permission())});
                }
                if (pluginManager.getPermission(protectionOptions.bypassPermission()) == null) {
                    pluginManager.addPermission(new Permission(protectionOptions.bypassPermission()));
                    this.debug(2, new Object[]{"Permission \"%s\" registered.".formatted(protectionOptions.bypassPermission())});
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to register the permission of the chest-protection", e);
        }
        this.blacklist = new ItemBlacklist(new File(this.getDataFolder(), "blacklist.yml"));
        this.reportManager = new GsonReportManager(new File(this.getDataFolder(), "reports"));
        this.debug(0, new Object[]{"Using gson report manager"});
        this.auditManager = new GsonAuditManager(new File(this.getDataFolder(), "audits"));
        this.debug(0, new Object[]{"Using gson audit manager"});
        this.debug(0, new Object[]{"Setting up the last safe location controller..."});
        this.lastSafeLocationController = new LastSafeLocationController(this);
        try {
            ParticleOptions particleOptions;
            BreakAnimationOptions breakAnimationOptions;
            this.debug(0, new Object[]{"Using death chest yaml storage"});
            this.deathChestStorage = !this.test ? new YamlStorage() : new MemoryStorage();
            this.deathChestController = new DeathChestController(this, this.getLogger(), this.auditManager, this.deathChestStorage);
            this.placeHolderController = new PlaceholderController(this.getDeathChestConfig(), this.deathChestController);
            this.debug(0, new Object[]{"Initializing death chest storage..."});
            this.deathChestStorage.init(this, this.deathChestStorage.getDefaultOptions());
            BlockView adapter = new BlockView(this);
            this.deathChestController.registerAdapter(adapter);
            this.getServer().getPluginManager().registerEvents((Listener)adapter, (Plugin)this);
            this.deathChestController.registerAdapter(new CloseInventoryView(this));
            this.deathChestController.registerAdapter(new ExpirationView(this));
            HologramOptions hologramOptions = this.getDeathChestConfig().hologramOptions();
            if (hologramOptions.enabled()) {
                this.deathChestController.registerAdapter(new HologramView(this, this.hologramController, hologramOptions, this.placeHolderController));
            }
            if ((breakAnimationOptions = this.getDeathChestConfig().breakAnimationOptions()).enabled()) {
                this.deathChestController.registerAdapter(new BreakAnimationView(this, this.breakAnimationService, breakAnimationOptions));
            }
            if ((particleOptions = this.getDeathChestConfig().particleOptions()).enabled()) {
                this.deathChestController.registerAdapter(new ParticleView(this, particleOptions));
            }
            this.debug(0, new Object[]{"Loading chests..."});
            this.deathChestController.loadChests();
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to initialize the storage. Please check your configuration file.");
            throw new RuntimeException(e);
        }
        CompatibilityLoader loader = new CompatibilityLoader();
        this.compatibilityManager = new CompatibilityManager(this, loader);
        this.compatibilityManager.registerCompatibility(LWCCompatibility.class);
        this.compatibilityManager.registerCompatibility(LocketteXCompatibility.class);
        this.compatibilityManager.registerCompatibility(PlaceholderAPICompatibility.class);
        this.compatibilityManager.enableCompatibilities();
        this.debug(0, new Object[]{"Registering event listeners..."});
        pluginManager.registerEvents((Listener)new SpawnChestListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChestInteractionListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChestDestroyListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new LastDeathChestListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ItemBlacklistListener(this.blacklist), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryChangeSlotItemListener(new InventoryHolder[0]), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryChangeSlotItemListener(this.blacklist), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerNotificationListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GlobalNotificationListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new LastSafeLocationListener(this), (Plugin)this);
        if (this.deathChestConfig.updateChecker()) {
            this.debug(0, new Object[]{"Starting update checker..."});
            this.updateController = new UpdateController(this);
            this.updateController.subscribe(new ConsoleNotificationView(this, this.getLogger()));
            this.updateController.subscribe(new AdminNotificationView(this));
            this.getServer().getPluginManager().registerEvents((Listener)new AdminJoinNotificationView(this, this.updateController), (Plugin)this);
        }
    }

    private void checkConfigVersion() {
        if (this.getConfig().getInt("config-version", 0) != 3) {
            this.debug(1, new Object[]{"Found old configuration file."});
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (configFile.isFile()) {
                File oldConfigFile = new File(this.getDataFolder(), "config.yml.old");
                boolean b = configFile.renameTo(oldConfigFile);
                this.debug(1, new Object[]{"Found old configuration file."});
                this.debug(1, new Object[]{"Renamed the config.yml -> config.yml.old"});
                if (!b) {
                    throw new IllegalStateException("Failed to rename the configuration file to old.");
                }
            }
        }
    }

    @Override
    public boolean isDebugMode() {
        return this.deathChestConfig != null && this.deathChestConfig.debug() || Boolean.getBoolean("deathchest.debug");
    }

    @Override
    @Nullable
    public DeathChestModel getLastChest(@NotNull Player player) {
        return this.lastDeathChests.get(player);
    }

    @Override
    public void saveChests() {
        this.deathChestController.saveChests();
    }

    public void reload() {
        this.onDisable();
        this.reloadConfig();
        this.initializeServices();
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.debug(0, new Object[]{"Checking config version..."});
        this.checkConfigVersion();
        this.saveDefaultConfig();
        this.debug(1, new Object[]{"Parsing configuration file..."});
        this.deathChestConfig = DeathChestConfig.load(this.getConfig());
        if (this.isDebugMode()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat(2, 2).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).create();
            this.debug(1, new Object[]{"Configuration: " + gson.toJson((Object)this.deathChestConfig)});
        }
    }

    @Override
    public boolean canPlaceChestAt(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        if (location.getY() < (double)world.getMinHeight()) {
            return false;
        }
        if (location.getY() >= (double)world.getMaxHeight()) {
            return false;
        }
        return this.deathChestController.getChest(location) == null && !location.getBlock().getType().isSolid() && location.getBlock().getType() != Material.NETHER_PORTAL;
    }

    @Override
    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location location, ItemStack ... items) {
        return this.createDeathChest(location, (Player)null, items);
    }

    @Override
    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location location, @Nullable Player player, ItemStack ... items) {
        return this.createDeathChest(location, -1L, player, items);
    }

    @Override
    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location location, long expireAt, @Nullable Player player, ItemStack ... items) {
        return this.createDeathChest(location, System.currentTimeMillis(), expireAt, player, items);
    }

    @Override
    @NotNull
    public DeathChestModel createDeathChest(@NotNull Location location, long createdAt, long expireAt, @Nullable Player player, boolean isProtected, ItemStack ... items) {
        return this.deathChestController.createChest(location, createdAt, expireAt, player, isProtected, items);
    }

    @Override
    @NotNull
    public @NotNull Stream<@NotNull DeathChestModel> getChests() {
        return this.deathChestController.getChests().stream();
    }

    @Override
    @NotNull
    public @NotNull Stream<@NotNull DeathChestModel> getChests(@NotNull World world) {
        return this.deathChestController.getChests(world).stream();
    }

    @Override
    public HologramService getHologramService() {
        return this.hologramController;
    }

    @Override
    @NotNull
    public ProtectionService getProtectionService() {
        return this.protectionService;
    }

    public String getPrefix() {
        return "\u00a7c\u1d05\u1d07\u1d00\u1d1b\u029c \u1d04\u029c\u1d07\ua731\u1d1b \u00a78\ufe33 \u00a7r";
    }

    @NotNull
    public File getFile() {
        return super.getFile();
    }

    public DeathChestConfig getDeathChestConfig() {
        return this.deathChestConfig;
    }

    @Override
    public BreakAnimationService getBreakAnimationService() {
        return this.breakAnimationService;
    }

    public ReportManager getReportManager() {
        return this.reportManager;
    }

    public AuditManager getAuditManager() {
        return this.auditManager;
    }

    public ItemBlacklist getBlacklist() {
        return this.blacklist;
    }

    @Nullable
    public UpdateController getUpdateController() {
        return this.updateController;
    }

    public PlaceholderController getPlaceHolderController() {
        return this.placeHolderController;
    }

    public HologramController getHologramController() {
        return this.hologramController;
    }

    public DeathChestStorage getDeathChestStorage() {
        return this.deathChestStorage;
    }

    public DeathChestController getDeathChestController() {
        return this.deathChestController;
    }

    public LastSafeLocationController getLastSafeLocationController() {
        return this.lastSafeLocationController;
    }

    public CompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    public boolean isTest() {
        return this.test;
    }

    public static boolean isPlaceholderAPIEnabled() {
        return placeholderAPIEnabled;
    }

    public Map<Player, DeathChestModel> getLastDeathChests() {
        return this.lastDeathChests;
    }

    public BukkitAudiences getAudiences() {
        return this.audiences;
    }
}

