/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest;

import com.github.devcyntrix.deathchest.config.InventoryOptions;
import com.github.devcyntrix.deathchest.controller.PlaceholderController;
import com.github.devcyntrix.hologram.api.Hologram;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeathChestModel
implements InventoryHolder {
    @Expose
    private Location location;
    @Expose
    private long createdAt;
    @Expose
    private long expireAt;
    @Expose
    @Nullable
    private OfflinePlayer owner;
    @Expose
    private boolean isProtected;
    @Expose(deserialize=false)
    private Inventory inventory;
    private transient BlockState previous;
    private transient Hologram hologram;
    private transient Integer breakingEntityId;
    private transient boolean isDeleting;
    private transient Set<Closeable> tasks = new HashSet<Closeable>();

    public DeathChestModel(Location location, long createdAt, long expireAt, @Nullable OfflinePlayer owner, boolean isProtected) {
        this.location = location;
        this.createdAt = createdAt;
        this.expireAt = expireAt;
        this.owner = owner;
        this.isProtected = isProtected;
    }

    @Nullable
    public World getWorld() {
        if (this.getLocation() == null) {
            return null;
        }
        return this.getLocation().getWorld();
    }

    public boolean isExpiring() {
        return this.expireAt > 0L;
    }

    public boolean isExpired() {
        return this.expireAt < System.currentTimeMillis();
    }

    public void cancelTasks() {
        for (Closeable closeable : this.tasks) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.tasks.clear();
    }

    public void dropItems() {
        this.dropItems(this.getLocation());
    }

    public void dropItems(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location.getWorld(), (Object)"invalid location because world is null");
        for (ItemStack itemStack : this.getInventory()) {
            if (itemStack == null) continue;
            location.getWorld().dropItemNaturally(location, itemStack);
        }
        this.inventory.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeathChestModel that = (DeathChestModel)o;
        return this.createdAt == that.createdAt && Objects.equal((Object)this.location, (Object)that.location) && Objects.equal((Object)this.owner, (Object)that.owner);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.location, this.createdAt, this.owner});
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", this.getLocation());
        map.put("createdAt", this.getCreatedAt());
        map.put("expireAt", this.getExpireAt());
        if (this.getOwner() != null) {
            map.put("player", this.getOwner().getUniqueId().toString());
        }
        map.put("protected", this.isProtected());
        ItemStack[] array = (ItemStack[])Arrays.stream(this.getInventory().getContents()).filter(itemStack -> itemStack != null && !itemStack.getType().isAir()).toArray(ItemStack[]::new);
        map.put("items", array);
        return map;
    }

    public static DeathChestModel deserialize(Map<String, Object> map, InventoryOptions options, PlaceholderController controller) {
        List stacks;
        long createdAt = Long.parseLong(map.get("createdAt").toString());
        long expireAt = Long.parseLong(map.get("expireAt").toString());
        Location location = (Location)map.get("location");
        if (location == null) {
            return null;
        }
        String player = (String)map.get("player");
        UUID playerId = player == null ? null : UUID.fromString(player);
        OfflinePlayer owner = playerId != null ? Bukkit.getOfflinePlayer((UUID)playerId) : null;
        boolean isProtected = false;
        Object o = map.get("protected");
        if (o != null) {
            isProtected = Boolean.parseBoolean(o.toString());
        }
        if ((stacks = (List)map.get("items")) == null) {
            return null;
        }
        ItemStack[] itemStacks = (ItemStack[])stacks.toArray(ItemStack[]::new);
        DeathChestModel model = new DeathChestModel(location, createdAt, expireAt, owner, isProtected);
        model.setInventory(options.createInventory(model, s -> controller.replace(model, (String)s), itemStacks));
        return model;
    }

    public Location getLocation() {
        return this.location;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    @Nullable
    public OfflinePlayer getOwner() {
        return this.owner;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BlockState getPrevious() {
        return this.previous;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public Integer getBreakingEntityId() {
        return this.breakingEntityId;
    }

    public boolean isDeleting() {
        return this.isDeleting;
    }

    public Set<Closeable> getTasks() {
        return this.tasks;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setExpireAt(long expireAt) {
        this.expireAt = expireAt;
    }

    public void setOwner(@Nullable OfflinePlayer owner) {
        this.owner = owner;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void setPrevious(BlockState previous) {
        this.previous = previous;
    }

    public void setHologram(Hologram hologram) {
        this.hologram = hologram;
    }

    public void setBreakingEntityId(Integer breakingEntityId) {
        this.breakingEntityId = breakingEntityId;
    }

    public void setDeleting(boolean isDeleting) {
        this.isDeleting = isDeleting;
    }

    public void setTasks(Set<Closeable> tasks) {
        this.tasks = tasks;
    }

    public String toString() {
        return "DeathChestModel(location=" + String.valueOf(this.getLocation()) + ", createdAt=" + this.getCreatedAt() + ", expireAt=" + this.getExpireAt() + ", owner=" + String.valueOf(this.getOwner()) + ", isProtected=" + this.isProtected() + ", inventory=" + String.valueOf(this.getInventory()) + ", previous=" + String.valueOf(this.getPrevious()) + ", hologram=" + String.valueOf(this.getHologram()) + ", breakingEntityId=" + this.getBreakingEntityId() + ", isDeleting=" + this.isDeleting() + ", tasks=" + String.valueOf(this.getTasks()) + ")";
    }

    public DeathChestModel() {
    }

    public DeathChestModel(Location location, long createdAt, long expireAt, @Nullable OfflinePlayer owner, boolean isProtected, Inventory inventory, BlockState previous, Hologram hologram, Integer breakingEntityId, boolean isDeleting, Set<Closeable> tasks) {
        this.location = location;
        this.createdAt = createdAt;
        this.expireAt = expireAt;
        this.owner = owner;
        this.isProtected = isProtected;
        this.inventory = inventory;
        this.previous = previous;
        this.hologram = hologram;
        this.breakingEntityId = breakingEntityId;
        this.isDeleting = isDeleting;
        this.tasks = tasks;
    }
}

