/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.api.event;

import com.github.devcyntrix.api.event.InventoryChangeSlotItemEvent;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InventoryChangeSlotItemListener
implements Listener {
    private final List<InventoryHolder> holders;

    public InventoryChangeSlotItemListener(InventoryHolder ... holders) {
        this.holders = Arrays.asList(holders);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClick(InventoryClickEvent event) {
        HumanEntity whoClicked = event.getWhoClicked();
        InventoryView view = event.getView();
        if (!this.holders.contains(view.getTopInventory().getHolder())) {
            return;
        }
        int rawSlot = event.getRawSlot();
        Inventory inventory = view.getInventory(rawSlot);
        ItemStack previous = view.getItem(event.getRawSlot());
        ItemStack cursor = event.getCursor();
        int prevAmount = previous != null ? previous.getAmount() : 0;
        ItemStack oldItem = null;
        switch (event.getAction()) {
            case PLACE_ONE: {
                ItemStack newItem = cursor.clone();
                newItem.setAmount(prevAmount + 1);
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, event.getSlot(), previous, newItem);
                itemEvent.setCancelled(event.isCancelled());
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                event.setCancelled(itemEvent.isCancelled());
                break;
            }
            case PLACE_ALL: {
                ItemStack newItem = cursor.clone();
                newItem.setAmount(cursor.getAmount() + prevAmount);
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, event.getSlot(), previous, newItem);
                itemEvent.setCancelled(event.isCancelled());
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                event.setCancelled(itemEvent.isCancelled());
                break;
            }
            case PICKUP_HALF: {
                ItemStack newItem = previous.clone();
                int amount = newItem.getAmount() / 2;
                if (amount > 0) {
                    newItem.setAmount(amount);
                } else {
                    newItem = null;
                }
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, event.getSlot(), previous, newItem);
                itemEvent.setCancelled(event.isCancelled());
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                event.setCancelled(itemEvent.isCancelled());
                break;
            }
            case PICKUP_ALL: {
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, event.getSlot(), previous, null);
                itemEvent.setCancelled(event.isCancelled());
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                event.setCancelled(itemEvent.isCancelled());
                break;
            }
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                oldItem = event.getHotbarButton() != -1 ? view.getBottomInventory().getItem(event.getHotbarButton()) : event.getWhoClicked().getInventory().getItemInOffHand();
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, view.getBottomInventory(), event.getHotbarButton(), oldItem, null);
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                if (itemEvent.isCancelled()) break;
                itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, view.convertSlot(event.getRawSlot()), view.getItem(event.getRawSlot()), oldItem);
                itemEvent.setCancelled(event.isCancelled());
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                event.setCancelled(itemEvent.isCancelled());
                HumanEntity humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) break;
                Player player = (Player)humanEntity;
                Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getPlugin(DeathChestPlugin.class), () -> ((Player)player).updateInventory());
                break;
            }
            case SWAP_WITH_CURSOR: {
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, event.getSlot(), previous, cursor);
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                if (itemEvent.isCancelled()) break;
                inventory.setItem(event.getSlot(), itemEvent.getTo());
                event.setCursor(itemEvent.getFrom());
                break;
            }
            case DROP_ONE_SLOT: 
            case DROP_ALL_SLOT: 
            case DROP_ALL_CURSOR: 
            case DROP_ONE_CURSOR: {
                break;
            }
            case COLLECT_TO_CURSOR: {
                event.setCancelled(true);
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, event.getSlot(), previous, null);
                itemEvent.setCancelled(event.isCancelled());
                Bukkit.getPluginManager().callEvent((Event)itemEvent);
                event.setCancelled(itemEvent.isCancelled());
                if (itemEvent.isCancelled()) break;
                ItemStack currentItem = event.getCurrentItem();
                if (currentItem == null) {
                    return;
                }
                event.setCancelled(true);
                Inventory otherInventory = view.getBottomInventory() == inventory ? view.getTopInventory() : view.getBottomInventory();
                int spreadAmount = currentItem.getAmount();
                for (int i = 0; i < otherInventory.getSize() && spreadAmount > 0; ++i) {
                    ItemStack item = otherInventory.getItem(i);
                    if (!currentItem.isSimilar(item) && item != null && !item.getType().isAir()) continue;
                    int maxStackSize = Math.min(currentItem.getMaxStackSize(), otherInventory.getMaxStackSize());
                    int currentAmount = 0;
                    if (item != null && !item.getType().isAir()) {
                        currentAmount = item.getAmount();
                        if (currentAmount >= maxStackSize) continue;
                        oldItem = item.clone();
                    } else {
                        item = currentItem.clone();
                    }
                    int added = Math.min(maxStackSize - currentAmount, spreadAmount);
                    item.setAmount(currentAmount + added);
                    itemEvent = new InventoryChangeSlotItemEvent(whoClicked, otherInventory, i, oldItem, item);
                    Bukkit.getPluginManager().callEvent((Event)itemEvent);
                    if (!itemEvent.isCancelled()) {
                        otherInventory.setItem(i, itemEvent.getTo());
                        spreadAmount -= added;
                        continue;
                    }
                    otherInventory.setItem(i, itemEvent.getFrom());
                }
                currentItem.setAmount(spreadAmount);
                view.setItem(event.getRawSlot(), currentItem);
            }
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        HumanEntity whoClicked = event.getWhoClicked();
        InventoryView view = event.getView();
        Set rawSlots = event.getRawSlots();
        int backAmount = 0;
        for (Integer rawSlot : rawSlots) {
            Inventory inventory = view.getInventory(rawSlot.intValue());
            Map newItems = event.getNewItems();
            ItemStack oldItem = view.getItem(rawSlot.intValue());
            ItemStack newItem = (ItemStack)newItems.get(rawSlot);
            InventoryChangeSlotItemEvent itemEvent = new InventoryChangeSlotItemEvent(whoClicked, inventory, view.convertSlot(rawSlot.intValue()), oldItem, newItem);
            Bukkit.getPluginManager().callEvent((Event)itemEvent);
            if (!itemEvent.isCancelled()) continue;
            int oldAmount = oldItem != null ? oldItem.getAmount() : 0;
            backAmount += newItem.getAmount() - oldAmount;
        }
        if (backAmount > 0) {
            int amount;
            ItemStack cursor = event.getCursor();
            if (cursor == null) {
                cursor = event.getOldCursor();
                amount = 0;
            } else {
                amount = cursor.getAmount();
            }
            cursor.setAmount(amount + backAmount);
            event.setCursor(cursor);
        }
    }
}

