/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.utils;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Base64;
import java.util.Optional;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    private static final FusionPaper fusion = (FusionPaper)FusionProvider.getInstance();

    @NotNull
    public static RegistryAccess getRegistryAccess() {
        return RegistryAccess.registryAccess();
    }

    @NotNull
    public static Optional<DataComponentType> getDataComponentType(@NotNull String value) {
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank while fetching a data component.", value);
            return Optional.empty();
        }
        DataComponentType type = (DataComponentType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.DATA_COMPONENT_TYPE).get(ItemUtils.getKey(value));
        return Optional.ofNullable(type);
    }

    @Nullable
    public static ItemType getItemType(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching item types.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid item key.", value);
            return null;
        }
        @Nullable ItemType itemType = (ItemType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ITEM).get(ItemUtils.getKey(value));
        if (itemType == null) {
            fusion.log("error", "{} is not a valid item type.", key.asString());
            return null;
        }
        return itemType;
    }

    @Nullable
    public static Sound getSound(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the sound.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid sound key.", value);
            return null;
        }
        @Nullable Sound sound = (Sound)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.SOUND_EVENT).get(ItemUtils.getKey(value));
        if (sound == null) {
            fusion.log("error", "{} is not a valid sound.", key.asString());
            return null;
        }
        return sound;
    }

    @Nullable
    public static Enchantment getEnchantment(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the enchantment.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid enchantment key.", value);
            return null;
        }
        @Nullable Enchantment enchantment = (Enchantment)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(key);
        if (enchantment == null) {
            fusion.log("error", "{} is not a valid enchantment.", key.asString());
            return null;
        }
        return enchantment;
    }

    @Nullable
    public static TrimPattern getTrimPattern(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the trim pattern.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid trim pattern key.", value);
            return null;
        }
        @Nullable TrimPattern trimPattern = (TrimPattern)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.TRIM_PATTERN).get(ItemUtils.getKey(value));
        if (trimPattern == null) {
            fusion.log("error", "{} is not a valid trim pattern.", key.asString());
            return null;
        }
        return trimPattern;
    }

    @Nullable
    public static TrimMaterial getTrimMaterial(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the trim material.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid trim material key.", value);
            return null;
        }
        @Nullable TrimMaterial trimMaterial = (TrimMaterial)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.TRIM_MATERIAL).get(ItemUtils.getKey(value));
        if (trimMaterial == null) {
            fusion.log("error", "{} is not a valid trim material.", key.asString());
            return null;
        }
        return trimMaterial;
    }

    @Nullable
    public static PotionType getPotionType(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the potion.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid potion type key.", value);
            return null;
        }
        @Nullable PotionType potionType = (PotionType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.POTION).get(ItemUtils.getKey(value));
        if (potionType == null) {
            fusion.log("error", "{} is not a valid potion.", key.asString());
            return null;
        }
        return potionType;
    }

    @Nullable
    public static PotionEffectType getPotionEffect(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the potion effect.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid potion effect key.", value);
            return null;
        }
        @Nullable PotionEffectType potionEffectType = (PotionEffectType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.MOB_EFFECT).get(ItemUtils.getKey(value));
        if (potionEffectType == null) {
            fusion.log("error", "{} is not a valid potion effect.", key.asString());
            return null;
        }
        return potionEffectType;
    }

    @Nullable
    public static Particle getParticleType(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the particle.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid potion type key.", value);
            return null;
        }
        @Nullable Particle particle = (Particle)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.PARTICLE_TYPE).get(ItemUtils.getKey(value));
        if (particle == null) {
            fusion.log("error", "{} is not a valid particle.", key.asString());
            return null;
        }
        return particle;
    }

    @Nullable
    public static PatternType getPatternType(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching banner pattern types!", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid potion type key.", value);
            return null;
        }
        @Nullable PatternType patternType = (PatternType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(ItemUtils.getKey(value));
        if (patternType == null) {
            fusion.log("error", "{} is not a valid banner pattern.", key.asString());
            return null;
        }
        return patternType;
    }

    @Nullable
    public static EntityType getEntity(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the entity.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid potion type key.", value);
            return null;
        }
        @Nullable EntityType entityType = (EntityType)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ENTITY_TYPE).get(ItemUtils.getKey(value));
        if (entityType == null) {
            fusion.log("error", "{} is not a valid entity.", key.asString());
            return null;
        }
        return entityType;
    }

    @Nullable
    public static Attribute getAttribute(@NotNull String value) {
        NamespacedKey key;
        if (value.isEmpty()) {
            fusion.log("error", "{} cannot be blank when fetching the attribute.", value);
            return null;
        }
        NamespacedKey namespacedKey = key = value.contains(":") ? NamespacedKey.fromString((String)value) : ItemUtils.getKey(value);
        if (key == null) {
            fusion.log("error", "{} is not a valid potion type key.", value);
            return null;
        }
        @Nullable Attribute attribute = (Attribute)ItemUtils.getRegistryAccess().getRegistry(RegistryKey.ATTRIBUTE).get(ItemUtils.getKey(value));
        if (attribute == null) {
            fusion.log("error", "{} is not a valid attribute.", key.asString());
            return null;
        }
        return attribute;
    }

    @NotNull
    private static NamespacedKey getKey(@NotNull String value) {
        return NamespacedKey.minecraft((String)value);
    }

    public static byte[] toBytes(@NotNull ItemStack itemStack) {
        return itemStack.serializeAsBytes();
    }

    @NotNull
    public static ItemStack fromBytes(byte @NotNull [] bytes) {
        return ItemStack.deserializeBytes((byte[])bytes);
    }

    @NotNull
    public static String toBase64(@NotNull ItemStack itemStack) {
        return Base64.getEncoder().encodeToString(itemStack.serializeAsBytes());
    }

    @NotNull
    public static ItemStack fromBase64(@NotNull String base64) {
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(base64));
    }
}

