/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.structure;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureRegistry {
    private final StructureManager manager;
    private final JavaPlugin plugin;

    public StructureRegistry(@NotNull JavaPlugin plugin, @NotNull StructureManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @Nullable
    public Structure getStructure(@NotNull String key) {
        return this.manager.getStructure(new NamespacedKey((Plugin)this.plugin, key));
    }

    public void registerStructure(@NotNull Path path, @NotNull String name) {
        StructureManager manager = this.manager;
        CompletableFuture.supplyAsync(() -> {
            try {
                return manager.loadStructure(path.toFile());
            }
            catch (IOException exception) {
                throw new FusionException("Failed to load structure!", exception);
            }
        }).thenAccept(structure -> {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, name);
            manager.registerStructure(key, structure);
        });
    }

    public void unregisterStructure(@NotNull String name) {
        if (this.getStructure(name) == null) {
            return;
        }
        StructureManager manager = this.manager;
        manager.unregisterStructure(new NamespacedKey((Plugin)this.plugin, name));
    }
}

