/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.builders.types.tools;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.datacomponent.item.Weapon;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.paper.builders.BaseItemBuilder;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ToolBuilder
extends BaseItemBuilder<ToolBuilder> {
    private Equippable.Builder equippable = null;
    private Weapon.Builder weapon = null;

    public ToolBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    public void addEquipmentComponent(@NotNull String equipmentSlot, @NotNull Consumer<Equippable.Builder> consumer) {
        if (!this.isArmor()) {
            return;
        }
        EquipmentSlot slot = EquipmentSlot.valueOf((String)equipmentSlot);
        this.equippable = Equippable.equippable((EquipmentSlot)slot);
        consumer.accept(this.equippable);
    }

    public void addWeaponComponent(@NotNull Consumer<Weapon.Builder> consumer) {
        if (!this.isTool()) {
            return;
        }
        this.weapon = Weapon.weapon();
        consumer.accept(this.weapon);
    }

    @Override
    public ToolBuilder build() {
        if (this.equippable != null) {
            this.itemStack.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)this.equippable.build()));
        }
        if (this.weapon != null) {
            this.itemStack.setData(DataComponentTypes.WEAPON, (Object)((Weapon)this.weapon.build()));
        }
        return this;
    }
}

