/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.builders.types.custom;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.Optional;
import libs.com.ryderbelserion.fusion.paper.builders.BaseItemBuilder;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CustomBuilder
extends BaseItemBuilder<CustomBuilder> {
    private final CustomModelData.Builder builder = CustomModelData.customModelData();
    private NamespacedKey itemModel;

    public CustomBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
        CustomModelData component;
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA) && (component = (CustomModelData)this.itemStack.getData(DataComponentTypes.CUSTOM_MODEL_DATA)) != null) {
            this.builder.addFloats(component.floats()).addStrings(component.strings()).addFlags(component.flags()).addColors(component.colors());
        }
    }

    @NotNull
    public CustomBuilder setCustomModelData(int customModelData) {
        if (customModelData == -1) {
            return this;
        }
        this.builder.addFloat((float)customModelData);
        return this;
    }

    @NotNull
    public CustomBuilder setCustomModelData(@NotNull String customModelData) {
        if (customModelData.isEmpty()) {
            return this;
        }
        Optional<Number> integer = this.fusion.getStringUtils().tryParseInt(customModelData);
        if (integer.isPresent()) {
            return this.setCustomModelData(integer.orElse(-1).intValue());
        }
        this.builder.addString(customModelData);
        return this;
    }

    @NotNull
    public CustomBuilder setItemModel(@NotNull String namespace, @NotNull String itemModel) {
        if (namespace.isEmpty() || itemModel.isEmpty()) {
            return this;
        }
        this.itemModel = new NamespacedKey(namespace, itemModel);
        return this;
    }

    @NotNull
    public CustomBuilder setItemModel(@NotNull String itemModel) {
        if (itemModel.isEmpty()) {
            return this;
        }
        this.itemModel = NamespacedKey.minecraft((String)itemModel);
        return this;
    }

    @Override
    public CustomBuilder build() {
        boolean isEmpty;
        if (this.itemModel != null) {
            this.itemStack.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel);
            return this;
        }
        CustomModelData modelData = (CustomModelData)this.builder.build();
        boolean bl = isEmpty = modelData.colors().isEmpty() && modelData.flags().isEmpty() && modelData.floats().isEmpty() && modelData.strings().isEmpty();
        if (isEmpty) {
            return this;
        }
        this.itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)this.builder.build()));
        return this;
    }
}

