/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.FusionKey;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.api.support.ModSupport;
import libs.com.ryderbelserion.fusion.core.api.support.objects.Mod;
import libs.com.ryderbelserion.fusion.core.utils.StringUtils;
import libs.com.ryderbelserion.fusion.paper.builders.gui.listeners.GuiListener;
import libs.com.ryderbelserion.fusion.paper.files.PaperFileManager;
import libs.com.ryderbelserion.fusion.paper.structure.StructureRegistry;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionPaper
extends FusionCore {
    private final PaperFileManager fileManager = new PaperFileManager(this);
    private PluginManager pluginManager;
    private StructureRegistry registry;
    private HeadDatabaseAPI api;
    private JavaPlugin plugin;
    private Server server;

    public FusionPaper(@NotNull JavaPlugin plugin) {
        super((FusionCore consumer) -> {
            consumer.setDataPath(plugin.getDataPath());
            consumer.setLogger(plugin.getComponentLogger());
        });
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.pluginManager = this.server.getPluginManager();
        this.registry = new StructureRegistry(this.plugin, this.server.getStructureManager());
    }

    public FusionPaper(@NotNull BootstrapContext context) {
        super((FusionCore consumer) -> {
            consumer.setDataPath(context.getDataDirectory());
            consumer.setLogger(context.getLogger());
        });
    }

    @Override
    @NotNull
    public final Component parse(@NotNull Audience audience, @NotNull String message, @NotNull Map<String, String> placeholders, @NotNull List<TagResolver> tags) {
        ArrayList<TagResolver> resolvers = new ArrayList<TagResolver>(tags);
        StringUtils utils = this.getStringUtils();
        placeholders.forEach((key, value) -> resolvers.add((TagResolver)Placeholder.parsed((String)utils.replaceAllBrackets((String)key).toLowerCase(), (String)value)));
        return MiniMessage.miniMessage().deserialize(this.papi(audience, utils.replaceBrackets(message)), !resolvers.isEmpty() ? TagResolver.resolver(resolvers) : TagResolver.empty()).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final String papi(@NotNull Audience audience, @NotNull String message) {
        String string;
        if (audience instanceof Player) {
            Player player = (Player)audience;
            if (this.getModManager().getMod(ModSupport.placeholder_api).isEnabled()) {
                string = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
                return string;
            }
        }
        string = message;
        return string;
    }

    @Override
    @NotNull
    public final FusionPaper init(@NotNull Consumer<FusionCore> fusion) {
        Path dataPath = this.getDataPath();
        if (Files.notExists(dataPath, new LinkOption[0])) {
            try {
                Files.createDirectory(dataPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.server = this.plugin.getServer();
        this.pluginManager = this.server.getPluginManager();
        this.registry = new StructureRegistry(this.plugin, this.server.getStructureManager());
        ModSupport.dependencies.forEach(dependency -> this.getModManager().addMod((FusionKey)dependency, new Mod()));
        if (this.isModReady(ModSupport.head_database) && this.api == null) {
            this.api = new HeadDatabaseAPI();
        }
        this.pluginManager.registerEvents((Listener)new GuiListener(), (Plugin)this.plugin);
        fusion.accept(this);
        FusionProvider.register(this);
        return this;
    }

    @Override
    @NotNull
    public final FusionCore reload() {
        this.config.reload();
        return this;
    }

    @Override
    @NotNull
    public final String chomp(@NotNull String value) {
        return org.apache.commons.lang3.StringUtils.chomp((String)value);
    }

    @NotNull
    public final PlayerProfile createProfile(@NotNull UUID uuid, @Nullable String name) {
        return this.server.createProfile(uuid, name);
    }

    @Override
    public boolean isModReady(@NotNull FusionKey key) {
        return this.pluginManager.isPluginEnabled(key.getValue());
    }

    @Override
    public PaperFileManager getFileManager() {
        return this.fileManager;
    }

    @NotNull
    public final StructureRegistry getRegistry() {
        if (this.registry == null) {
            throw new FusionException("An error occurred while trying to get the structure registry instance.");
        }
        return this.registry;
    }

    @NotNull
    public final Optional<HeadDatabaseAPI> getHeadDatabaseAPI() {
        return Optional.ofNullable(this.api);
    }

    @NotNull
    public final FusionPaper setJavaPlugin(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        return this;
    }

    @NotNull
    public final JavaPlugin getPlugin() {
        return this.plugin;
    }
}

