/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.api.interfaces.IStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class StringUtils
implements IStringUtils {
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final Pattern ANGLE_PATTERN = Pattern.compile("[<>]");
    private final FusionCore fusion;

    public StringUtils(@NotNull FusionCore fusion) {
        this.fusion = fusion;
    }

    @Override
    @NotNull
    public String toString(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder(list.size());
        for (String line : list) {
            message.append(line).append("\n");
        }
        return this.fusion.chomp(message.toString());
    }

    @Override
    @NotNull
    public Component parseComponent(@NotNull String message, TagResolver ... tags) {
        if (message.isEmpty()) {
            return Component.empty();
        }
        return MiniMessage.miniMessage().deserialize(message, tags).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    @Override
    @NotNull
    public Component parseComponent(@NotNull String message) {
        return this.parseComponent(message, TagResolver.empty());
    }

    @Override
    @NotNull
    public String fromComponent(@NotNull Component component, boolean isMessage) {
        String value = (String)MiniMessage.miniMessage().serialize(component);
        return isMessage ? value.replace("\\<", "<") : value;
    }

    @Override
    @NotNull
    public List<String> fromComponent(@NotNull List<Component> components) {
        ArrayList<String> keys = new ArrayList<String>(components.size());
        components.forEach(component -> keys.add(this.fromComponent((Component)component)));
        return keys;
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String component) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(component.replace("\u00a7", "&"));
    }

    @Override
    @NotNull
    public List<Component> fromLegacy(final @NotNull List<String> lore) {
        return new ArrayList<Component>(lore.size()){
            {
                super(arg0);
                lore.forEach((? super T line) -> this.add(StringUtils.this.fromLegacy((String)line)));
            }
        };
    }

    @Override
    @NotNull
    public List<String> convertLegacy(final @NotNull List<String> components, final boolean isMessage) {
        return new ArrayList<String>(components.size()){
            {
                super(arg0);
                components.forEach((? super T line) -> this.add(StringUtils.this.convertLegacy((String)line, isMessage)));
            }
        };
    }

    @Override
    @NotNull
    public String convertLegacy(@NotNull String component, boolean isMessage) {
        return this.fromComponent(this.fromLegacy(component), isMessage);
    }

    @Override
    @NotNull
    public String replaceAngleBrackets(@NotNull String input) {
        return ANGLE_PATTERN.matcher(input).replaceAll("");
    }

    @Override
    @NotNull
    public String replaceBrackets(@NotNull String input) {
        return BRACKET_PATTERN.matcher(input).replaceAll("<$1>");
    }

    @Override
    @NotNull
    public Optional<Number> tryParseInt(@NotNull String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public Optional<Boolean> tryParseBoolean(@NotNull String value) {
        try {
            return Optional.of(Boolean.parseBoolean(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public String fromInteger(int number) {
        return NumberFormat.getIntegerInstance(Locale.US).format(number);
    }

    @Override
    @NotNull
    public String fromDouble(double number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    @Override
    @NotNull
    public String format(double value) {
        DecimalFormat decimalFormat = new DecimalFormat(this.fusion.getNumberFormat());
        decimalFormat.setRoundingMode(this.getRoundingMode());
        return decimalFormat.format(value);
    }

    @Override
    @NotNull
    public RoundingMode getRoundingMode() {
        return RoundingMode.valueOf(this.fusion.getRounding().toUpperCase());
    }
}

