/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.files.types;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import java.nio.file.Path;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.files.FileManager;
import libs.com.ryderbelserion.fusion.core.files.enums.FileType;
import libs.com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import org.jetbrains.annotations.NotNull;

public final class JaluCustomFile
extends ICustomFile<JaluCustomFile, SettingsManager, SettingsManagerBuilder, YamlFileResourceOptions.Builder> {
    private final Consumer<SettingsManagerBuilder> builder;

    public JaluCustomFile(@NotNull FileManager fileManager, @NotNull Path path, @NotNull Consumer<YamlFileResourceOptions.Builder> options, @NotNull Consumer<SettingsManagerBuilder> builder) {
        super(fileManager, path);
        this.options = YamlFileResourceOptions.builder();
        options.accept((YamlFileResourceOptions.Builder)this.options);
        this.builder = builder;
    }

    @Override
    @NotNull
    public SettingsManager loadConfig() {
        if (this.configuration == null) {
            SettingsManagerBuilder builder = SettingsManagerBuilder.withYamlFile(this.getPath(), ((YamlFileResourceOptions.Builder)this.options).build());
            builder.useDefaultMigrationService();
            this.builder.accept(builder);
            return builder.create();
        }
        ((SettingsManager)this.configuration).reload();
        return (SettingsManager)this.configuration;
    }

    @Override
    public void saveConfig() {
        ((SettingsManager)this.configuration).save();
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return FileType.JALU;
    }
}

