/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.files.interfaces;

import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.files.enums.FileAction;
import libs.com.ryderbelserion.fusion.core.files.enums.FileType;
import libs.com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import libs.com.ryderbelserion.fusion.core.files.types.JaluCustomFile;
import libs.com.ryderbelserion.fusion.core.files.types.JsonCustomFile;
import libs.com.ryderbelserion.fusion.core.files.types.LogCustomFile;
import libs.com.ryderbelserion.fusion.core.files.types.YamlCustomFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IFileManager<I> {
    @NotNull
    public abstract I addFolder(@NotNull Path var1, @NotNull FileType var2, @NotNull Consumer<ICustomFile<?, ?, ?, ?>> var3);

    @NotNull
    public I addFolder(@NotNull Path folder, @NotNull FileType fileType) {
        return this.addFolder(folder, fileType, (ICustomFile<?, ?, ?, ?> consumer) -> consumer.addAction(FileAction.EXTRACT_FOLDER));
    }

    @NotNull
    public abstract I addFile(@NotNull Path var1, @NotNull FileType var2, @NotNull Consumer<ICustomFile<?, ?, ?, ?>> var3);

    @NotNull
    public I addFile(@NotNull Path path, @NotNull FileType fileType) {
        return this.addFile(path, fileType, (ICustomFile<?, ?, ?, ?> consumer) -> consumer.addAction(FileAction.EXTRACT_FILE));
    }

    @NotNull
    public abstract I addFolder(@NotNull Path var1, @NotNull Consumer<YamlFileResourceOptions.Builder> var2, @NotNull Consumer<SettingsManagerBuilder> var3);

    @NotNull
    public abstract I addFile(@NotNull Path var1, @NotNull Consumer<YamlFileResourceOptions.Builder> var2, @NotNull Consumer<SettingsManagerBuilder> var3);

    @NotNull
    public abstract I removeFile(@NotNull Path var1);

    @NotNull
    public abstract I reloadFile(@NotNull Path var1);

    @NotNull
    public abstract I saveFile(@NotNull Path var1);

    @NotNull
    public abstract I purge();

    @NotNull
    public abstract I refresh(boolean var1);

    public abstract boolean hasFile(@NotNull Path var1);

    @NotNull
    public abstract Optional<ICustomFile<?, ?, ?, ?>> getFile(@NotNull Path var1);

    @NotNull
    public abstract JaluCustomFile buildJaluFile(@NotNull Path var1, @NotNull Consumer<YamlFileResourceOptions.Builder> var2, @NotNull Consumer<SettingsManagerBuilder> var3);

    @NotNull
    public abstract YamlCustomFile buildYamlFile(@NotNull Path var1, @NotNull Consumer<YamlCustomFile> var2);

    @NotNull
    public abstract JsonCustomFile buildJsonFile(@NotNull Path var1, @NotNull Consumer<JsonCustomFile> var2);

    @NotNull
    public abstract LogCustomFile buildLogFile(@NotNull Path var1, @NotNull Consumer<LogCustomFile> var2);

    @NotNull
    public Optional<YamlCustomFile> getYamlFile(@NotNull Path path) {
        return this.getFile(path).map(YamlCustomFile.class::cast);
    }

    @NotNull
    public Optional<JsonCustomFile> getJsonFile(@NotNull Path path) {
        return this.getFile(path).map(JsonCustomFile.class::cast);
    }

    @NotNull
    public Optional<JaluCustomFile> getJaluFile(@NotNull Path path) {
        return this.getFile(path).map(JaluCustomFile.class::cast);
    }

    @NotNull
    public Optional<LogCustomFile> getLogFile(@NotNull Path path) {
        return this.getFile(path).map(LogCustomFile.class::cast);
    }

    @NotNull
    public abstract I extractFolder(@NotNull String var1, @NotNull Path var2);

    @NotNull
    public abstract I extractFile(@NotNull Path var1);

    @NotNull
    public abstract I compressFolder(@NotNull Path var1, @NotNull String var2);

    @NotNull
    public abstract I compressFile(@NotNull Path var1, @Nullable Path var2, @NotNull String var3);

    @NotNull
    public abstract I writeFile(@NotNull Path var1, @NotNull String var2);

    public abstract int getFileCount(@NotNull Path var1, @NotNull String var2);

    @NotNull
    public I compressFile(@NotNull Path path, @NotNull String content) {
        return this.compressFile(path, null, content);
    }

    @NotNull
    public I compressFile(@NotNull Path path, @NotNull Path folder) {
        return this.compressFile(path, folder, "");
    }

    @NotNull
    public I compressFile(@NotNull Path path) {
        return this.compressFile(path, null, "");
    }
}

