/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.files.interfaces;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.files.FileManager;
import libs.com.ryderbelserion.fusion.core.files.enums.FileAction;
import libs.com.ryderbelserion.fusion.core.files.enums.FileType;
import org.jetbrains.annotations.NotNull;

public abstract class ICustomFile<I, C, L, O> {
    protected final List<FileAction> actions = new ArrayList<FileAction>();
    protected final FileManager fileManager;
    protected C configuration;
    protected L loader;
    protected O options = null;
    protected FileType fileType;
    protected Path path;

    public ICustomFile(@NotNull FileManager fileManager, @NotNull Path path) {
        this.fileManager = fileManager;
        this.path = path;
    }

    @NotNull
    public String getStringValueWithDefault(@NotNull String defaultValue, Object ... path) {
        return "";
    }

    @NotNull
    public String getStringValue(Object ... path) {
        return this.getStringValueWithDefault("", path);
    }

    public boolean getBooleanValueWithDefault(boolean defaultValue, Object ... path) {
        return false;
    }

    public boolean getBooleanValue(Object ... path) {
        return this.getBooleanValueWithDefault(false, path);
    }

    public double getDoubleValueWithDefault(double defaultValue, Object ... path) {
        return -1.0;
    }

    public double getDoubleValue(Object ... path) {
        return this.getDoubleValueWithDefault(0.0, path);
    }

    public long getLongValueWithDefault(long defaultValue, Object ... path) {
        return -1L;
    }

    public long getLongValue(Object ... path) {
        return this.getLongValueWithDefault(0L, path);
    }

    public int getIntValueWithDefault(int defaultValue, Object ... path) {
        return -1;
    }

    public int getIntValue(Object ... path) {
        return this.getIntValueWithDefault(0, path);
    }

    @NotNull
    public List<String> getStringList(@NotNull List<String> defaultValue, Object ... path) {
        return List.of();
    }

    @NotNull
    public List<String> getStringList(Object ... path) {
        return this.getStringList(List.of(), path);
    }

    public void saveConfig(@NotNull String content) throws IOException {
        this.saveConfig();
    }

    public void saveConfig() throws IOException {
    }

    @NotNull
    public abstract C loadConfig() throws IOException;

    @NotNull
    public C getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public I load() {
        if (this.isDirectory()) {
            return (I)this;
        }
        Path path = this.getPath();
        if (this.hasAction(FileAction.EXTRACT_FILE)) {
            this.fileManager.extractFile(path);
        }
        if (this.hasAction(FileAction.EXTRACT_FOLDER)) {
            this.fileManager.extractFolder(path.getFileName().toString(), path.getParent());
        }
        this.configuration = CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadConfig();
            }
            catch (IOException exception) {
                throw new FusionException("Failed to load file %s".formatted(this.getPath()), exception);
            }
        }).join();
        return (I)this;
    }

    @NotNull
    public I save(@NotNull String content) {
        if (this.isDirectory()) {
            return (I)this;
        }
        if (this.configuration == null) {
            return (I)this;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.saveConfig(content);
            }
            catch (IOException exception) {
                throw new FusionException("Failed to save content for %s".formatted(this.getPath()), exception);
            }
        });
        return (I)this;
    }

    @NotNull
    public I save() {
        return this.save("");
    }

    public boolean isLoaded() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void setOptions(@NotNull Consumer<O> options) {
        options.accept(this.options);
    }

    public void removeAction(@NotNull FileAction action) {
        this.actions.remove((Object)action);
    }

    public boolean hasAction(@NotNull FileAction action) {
        return this.actions.contains((Object)action);
    }

    public void addAction(@NotNull FileAction action) {
        this.actions.add(action);
    }

    @NotNull
    public O getOptions() {
        return this.options;
    }

    @NotNull
    public String getFileName() {
        return this.path.getFileName().toString();
    }

    @NotNull
    public String getPrettyName() {
        return this.getFileName().replace(this.getFileType().getExtension(), "");
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return Files.isDirectory(this.getPath(), new LinkOption[0]);
    }

    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    public void setLoader(@NotNull L loader) {
        this.loader = loader;
    }
}

