/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.FusionConfig;
import libs.com.ryderbelserion.fusion.core.FusionKey;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.api.interfaces.IFusionCore;
import libs.com.ryderbelserion.fusion.core.api.support.ModManager;
import libs.com.ryderbelserion.fusion.core.utils.StringUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FusionCore
implements IFusionCore {
    private final StringUtils stringUtils;
    private final ModManager modManager;
    protected final SettingsManager config;
    protected ComponentLogger logger;
    protected Path dataPath;

    public FusionCore(@NotNull Consumer<FusionCore> consumer) {
        consumer.accept(this);
        this.config = SettingsManagerBuilder.withYamlFile(this.dataPath.resolve("fusion.yml")).useDefaultMigrationService().configurationData(FusionConfig.class).create();
        this.stringUtils = new StringUtils(this);
        this.modManager = new ModManager(this);
    }

    public abstract Component parse(@NotNull Audience var1, @NotNull String var2, @NotNull Map<String, String> var3, @NotNull List<TagResolver> var4);

    public Component parse(@NotNull Audience audience, @NotNull String message, @NotNull Map<String, String> placeholders) {
        return this.parse(audience, message, placeholders, List.of());
    }

    public Component parse(@NotNull Audience audience, @NotNull String message) {
        return this.parse(audience, message, new HashMap<String, String>());
    }

    public Component parse(@NotNull String message) {
        return this.parse(Audience.empty(), message, new HashMap<String, String>());
    }

    @Nullable
    public <T> T createProfile(@NotNull UUID uuid, @Nullable String name) {
        return null;
    }

    public abstract String papi(@NotNull Audience var1, @NotNull String var2);

    public abstract FusionCore init(@NotNull Consumer<FusionCore> var1);

    public FusionCore init() {
        return this.init(fusion -> {});
    }

    public abstract boolean isModReady(@NotNull FusionKey var1);

    public abstract FusionCore reload();

    public void log(@NotNull String type, @NotNull String message, @NotNull Throwable throwable) {
        if (!this.isVerbose()) {
            return;
        }
        Component component = MiniMessage.miniMessage().deserialize((Object)message);
        switch (type) {
            case "info": {
                this.logger.info(component, throwable);
                break;
            }
            case "error": {
                this.logger.error(component, throwable);
                break;
            }
            case "warn": {
                this.logger.warn(component, throwable);
            }
        }
    }

    public void log(@NotNull String type, @NotNull String message, Object ... args) {
        if (!this.isVerbose()) {
            return;
        }
        Component component = MiniMessage.miniMessage().deserialize((Object)message);
        switch (type) {
            case "info": {
                this.logger.info(component, args);
                break;
            }
            case "error": {
                this.logger.error(component, args);
                break;
            }
            case "warn": {
                this.logger.warn(component, args);
            }
        }
    }

    public String chomp(@NotNull String value) {
        return "";
    }

    @Override
    public List<Path> getFiles(@NotNull Path path, final @NotNull List<String> extensions, int depth) {
        final ArrayList<Path> files = new ArrayList<Path>();
        if (Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return new ArrayList<Path>();
        }
        try {
            Files.walkFileTree(path, new HashSet<FileVisitOption>(), Math.max(depth, 1), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attributes) {
                    String fileName = path.getFileName().toString();
                    extensions.forEach(extension -> {
                        if (fileName.endsWith((String)extension)) {
                            files.add(path);
                        }
                    });
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exception) {
            throw new FusionException("Failed to get a list of files", exception);
        }
        return files;
    }

    @Override
    public List<String> getFileNames(@NotNull String folder, @NotNull Path path, @NotNull String extension, int depth, boolean removeExtension) {
        List<Path> files = this.getFiles(folder.isEmpty() ? path : path.resolve(folder), List.of(extension), depth);
        ArrayList<String> names = new ArrayList<String>();
        for (Path key : files) {
            String fileName = key.getFileName().toString();
            if (!fileName.endsWith(extension)) continue;
            names.add(removeExtension ? fileName.replace(extension, "") : fileName);
        }
        return names;
    }

    @Override
    public void deleteDirectory(@NotNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> contents = Files.newDirectoryStream(path);){
            for (Path entry : contents) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.deleteDirectory(entry);
                    continue;
                }
                Files.delete(entry);
            }
        }
        Files.deleteIfExists(path);
    }

    @Override
    public ModManager getModManager() {
        return this.modManager;
    }

    @Override
    public StringUtils getStringUtils() {
        return this.stringUtils;
    }

    @Override
    public void setDataPath(@NotNull Path dataPath) {
        if (this.dataPath != null) {
            return;
        }
        this.dataPath = dataPath;
    }

    @Override
    public void setLogger(@NotNull ComponentLogger logger) {
        if (this.logger != null) {
            return;
        }
        this.logger = logger;
    }

    @Override
    @NotNull
    public Path getDataPath() {
        return this.dataPath;
    }

    @Override
    public boolean isVerbose() {
        return this.config.getProperty(FusionConfig.is_verbose);
    }

    @Override
    public String getNumberFormat() {
        return this.config.getProperty(FusionConfig.number_format);
    }

    @Override
    public String getRounding() {
        return this.config.getProperty(FusionConfig.rounding_format);
    }

    @Override
    public String getCustomItemsPlugin() {
        return this.config.getProperty(FusionConfig.custom_items_plugin);
    }

    @Override
    public int getDepth() {
        return this.config.getProperty(FusionConfig.recursion_depth);
    }
}

