/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import dev.triumphteam.cmd.core.util.EnumUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class EnumSuggestion<S, ST>
implements InternalSuggestion.Simple<S, ST> {
    private final Class<? extends Enum<?>> enumType;
    private final SuggestionMapper<ST> mapper;
    private final SuggestionMethod method;
    private final boolean suggestLowercase;

    public EnumSuggestion(@NotNull Class<? extends Enum<?>> enumType, @NotNull SuggestionMapper<ST> mapper, @NotNull SuggestionMethod method, boolean suggestLowercase) {
        this.enumType = enumType;
        this.mapper = mapper;
        this.method = method;
        this.suggestLowercase = suggestLowercase;
        EnumUtils.populateCache(enumType);
    }

    @Override
    @NotNull
    public List<ST> getSuggestions(@NotNull S sender, @NotNull String current, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap) {
        List<String> suggestions = EnumUtils.getEnumConstants(this.enumType).values().stream().map(it -> {
            Enum constant = (Enum)it.get();
            if (constant == null) {
                return null;
            }
            String name = constant.name();
            return this.suggestLowercase ? name.toLowerCase() : name;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return this.mapper.filter(current, this.mapper.map(suggestions), this.method);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumSuggestion that = (EnumSuggestion)o;
        return this.suggestLowercase == that.suggestLowercase && Objects.equals(this.enumType, that.enumType) && Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.enumType, this.suggestLowercase, this.mapper);
    }

    @NotNull
    public String toString() {
        return "EnumSuggestion{enumType=" + this.enumType + ", suggestLowercase=" + this.suggestLowercase + ", mapper=" + this.mapper + '}';
    }
}

