/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.processor;

import com.google.common.base.CaseFormat;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Description;
import dev.triumphteam.cmd.core.annotations.Join;
import dev.triumphteam.cmd.core.annotations.Optional;
import dev.triumphteam.cmd.core.annotations.Split;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.ArgumentResolver;
import dev.triumphteam.cmd.core.argument.CollectionInternalArgument;
import dev.triumphteam.cmd.core.argument.EnumInternalArgument;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.JoinedStringInternalArgument;
import dev.triumphteam.cmd.core.argument.ResolverInternalArgument;
import dev.triumphteam.cmd.core.argument.SplitStringInternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.argument.UnknownInternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.Argument;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import dev.triumphteam.cmd.core.argument.keyed.Arguments;
import dev.triumphteam.cmd.core.argument.keyed.Flag;
import dev.triumphteam.cmd.core.argument.keyed.Flags;
import dev.triumphteam.cmd.core.argument.keyed.Keyed;
import dev.triumphteam.cmd.core.argument.keyed.KeyedInternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.ListArgument;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.extension.CommandOptions;
import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.extension.registry.ArgumentRegistry;
import dev.triumphteam.cmd.core.extension.registry.RegistryContainer;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import dev.triumphteam.cmd.core.suggestion.EnumSuggestion;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import dev.triumphteam.cmd.core.suggestion.SimpleSuggestion;
import dev.triumphteam.cmd.core.suggestion.SimpleSuggestionHolder;
import dev.triumphteam.cmd.core.suggestion.SuggestionContext;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import dev.triumphteam.cmd.core.suggestion.SuggestionRegistry;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCommandProcessor<D, S, ST>
implements CommandProcessor<D, S, ST> {
    private static final Set<Class<?>> SUPPORTED_COLLECTIONS = new HashSet<Class>(Arrays.asList(List.class, Set.class));
    private final Object invocationInstance;
    private final String name;
    private final List<String> aliases;
    private final Syntax syntax;
    private final AnnotatedElement annotatedElement;
    private final RegistryContainer<D, S, ST> registryContainer;
    private final SuggestionRegistry<S, ST> suggestionRegistry;
    private final ArgumentRegistry<S, ST> argumentRegistry;
    private final CommandOptions<?, ?, D, S, ST> commandOptions;
    private final CommandMeta parentMeta;
    private final Map<SuggestionKey, InternalSuggestion<S, ST>> localSuggestions;
    private final SuggestionMapper<ST> suggestionMapper;

    AbstractCommandProcessor(@NotNull Object invocationInstance, @NotNull AnnotatedElement annotatedElement, @NotNull RegistryContainer<D, S, ST> registryContainer, @NotNull CommandOptions<?, ?, D, S, ST> commandOptions, @NotNull CommandMeta parentMeta) {
        this.invocationInstance = invocationInstance;
        this.annotatedElement = annotatedElement;
        this.name = this.nameOf();
        this.aliases = this.aliasesOf();
        this.parentMeta = parentMeta;
        this.commandOptions = commandOptions;
        this.registryContainer = registryContainer;
        this.suggestionRegistry = registryContainer.getSuggestionRegistry();
        this.argumentRegistry = registryContainer.getArgumentRegistry();
        this.suggestionMapper = commandOptions.getCommandExtensions().getSuggestionMapper();
        this.syntax = annotatedElement.getAnnotation(Syntax.class);
        this.localSuggestions = this.collectLocalSuggestions();
    }

    protected abstract String defaultCommandName();

    @Override
    @NotNull
    public RegistryContainer<D, S, ST> getRegistryContainer() {
        return this.registryContainer;
    }

    @Override
    @NotNull
    public CommandOptions<?, ?, D, S, ST> getCommandOptions() {
        return this.commandOptions;
    }

    @NotNull
    protected CommandMeta getParentMeta() {
        return this.parentMeta;
    }

    @Override
    @Nullable
    public Syntax getSyntaxAnnotation() {
        return this.syntax;
    }

    @Contract(value="_ -> new")
    @NotNull
    protected CommandRegistrationException createException(@NotNull String message) {
        return new CommandRegistrationException(message, this.annotatedElement, this.invocationInstance.getClass());
    }

    @Nullable
    private String nameOf() {
        Command commandAnnotation = this.annotatedElement.getAnnotation(Command.class);
        if (commandAnnotation == null) {
            return null;
        }
        String name = commandAnnotation.value();
        if (name.isEmpty()) {
            return this.defaultCommandName();
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, commandAnnotation.value());
    }

    @Nullable
    private List<String> aliasesOf() {
        Command commandAnnotation = this.annotatedElement.getAnnotation(Command.class);
        if (commandAnnotation == null) {
            return null;
        }
        return Arrays.stream(commandAnnotation.alias()).map(it -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, it)).collect(Collectors.toList());
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    protected InternalArgument<S, ST> argumentFromParameter(@NotNull CommandMeta meta, @NotNull Parameter parameter, @NotNull List<String> argDescriptions, @NotNull Map<Integer, InternalSuggestion<S, ST>> suggestions, @NotNull ArgumentGroup<Flag> flagGroup, @NotNull ArgumentGroup<Argument> argumentGroup, int position) {
        String value;
        boolean isOptional;
        Class<?> type = parameter.getType();
        String argumentName = this.getArgName(parameter);
        String argumentDescription = this.getArgumentDescription(argDescriptions, parameter, position);
        Optional optionalAnnotation = parameter.getAnnotation(Optional.class);
        boolean bl = isOptional = optionalAnnotation != null;
        String defaultValue = optionalAnnotation == null ? null : ((value = optionalAnnotation.defaultValue()).isEmpty() ? null : value);
        if (SUPPORTED_COLLECTIONS.stream().anyMatch(it -> it.isAssignableFrom(type))) {
            Class<?> collectionType = this.getGenericType(parameter);
            StringInternalArgument<S, ST> argument = this.createSimpleArgument(meta, collectionType, argumentName, argumentDescription, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), null, true);
            if (argument instanceof UnknownInternalArgument) {
                throw this.createException("No internalArgument of type \"" + argument.getType().getName() + "\" registered");
            }
            Split splitAnnotation = parameter.getAnnotation(Split.class);
            if (splitAnnotation != null) {
                return new SplitStringInternalArgument<S, ST>(meta, argumentName, argumentDescription, splitAnnotation.value(), argument, type, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), defaultValue, isOptional);
            }
            return new CollectionInternalArgument<S, ST>(meta, argumentName, argumentDescription, argument, type, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), defaultValue, isOptional);
        }
        Join joinAnnotation = parameter.getAnnotation(Join.class);
        if (type == String.class && joinAnnotation != null) {
            return new JoinedStringInternalArgument<S, ST>(meta, argumentName, argumentDescription, joinAnnotation.value(), suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), defaultValue, isOptional);
        }
        if (Keyed.class.isAssignableFrom(type)) {
            if (type == Arguments.class) {
                if (argumentGroup.isEmpty()) {
                    throw this.createException("No named arguments found, if you want only Flags use the \"" + Flags.class.getSimpleName() + "\" argument instead");
                }
            } else if (type == Flags.class && flagGroup.isEmpty()) {
                throw this.createException("No declared flags found, make sure you have registered or declared some, or make sure the key is correct.");
            }
            return new KeyedInternalArgument<S, ST>(meta, argumentName, argumentDescription, this.createFlagInternals(meta, flagGroup), this.createNamedArgumentInternals(meta, argumentGroup), flagGroup, argumentGroup, this.suggestionMapper);
        }
        return this.createSimpleArgument(meta, type, argumentName, argumentDescription, suggestions.getOrDefault(position, this.suggestionFromParam(parameter)), defaultValue, isOptional);
    }

    @NotNull
    protected StringInternalArgument<S, ST> createSimpleArgument(@NotNull CommandMeta meta, @NotNull Class<?> type, @NotNull String name, @NotNull String description, @NotNull InternalSuggestion<S, ST> suggestion, @Nullable String defaultValue, boolean optional) {
        ArgumentResolver<S> resolver = this.argumentRegistry.getResolver(type);
        if (resolver == null) {
            if (Enum.class.isAssignableFrom(type)) {
                return new EnumInternalArgument<S, ST>(meta, name, description, (Class<Enum<?>>)type, suggestion, defaultValue, optional);
            }
            InternalArgument.Factory<S, ST> factory = this.argumentRegistry.getFactory(type);
            if (factory != null) {
                return factory.create(meta, name, description, type, suggestion, optional);
            }
            return new UnknownInternalArgument(type);
        }
        return new ResolverInternalArgument<S, ST>(meta, name, description, type, resolver, suggestion, defaultValue, optional);
    }

    private Map<Flag, StringInternalArgument<S, ST>> createFlagInternals(@NotNull CommandMeta meta, @NotNull ArgumentGroup<Flag> group) {
        HashMap<Flag, StringInternalArgument<S, ST>> internalArguments = new HashMap<Flag, StringInternalArgument<S, ST>>();
        for (Flag flag : group.getAll()) {
            Class<?> argType = flag.getArgument();
            InternalSuggestion<S, ST> suggestion = this.createSuggestion(flag.getSuggestion(), argType, SuggestionMethod.STARTS_WITH, "");
            internalArguments.put(flag, this.createSimpleArgument(meta, argType, "", flag.getDescription(), suggestion, null, true));
        }
        return internalArguments;
    }

    private Map<Argument, StringInternalArgument<S, ST>> createNamedArgumentInternals(@NotNull CommandMeta meta, @NotNull ArgumentGroup<Argument> group) {
        HashMap<Argument, StringInternalArgument<S, ST>> internalArguments = new HashMap<Argument, StringInternalArgument<S, ST>>();
        for (Argument argument : group.getAll()) {
            Class<?> argType = argument.getType();
            InternalSuggestion<S, ST> suggestion = this.createSuggestion(argument.getSuggestion(), argType, SuggestionMethod.STARTS_WITH, "");
            if (argument instanceof ListArgument) {
                ListArgument listArgument = (ListArgument)argument;
                StringInternalArgument<S, ST> internalArgument = this.createSimpleArgument(meta, listArgument.getType(), listArgument.getName(), listArgument.getDescription(), suggestion, null, true);
                internalArguments.put(argument, new SplitStringInternalArgument<S, ST>(meta, listArgument.getName(), listArgument.getDescription(), listArgument.getSeparator(), internalArgument, listArgument.getType(), suggestion, null, true));
                continue;
            }
            internalArguments.put(argument, this.createSimpleArgument(meta, argType, argument.getName(), argument.getDescription(), suggestion, null, true));
        }
        return internalArguments;
    }

    @NotNull
    private String getArgName(@NotNull Parameter parameter) {
        ArgName argNameAnnotation = parameter.getAnnotation(ArgName.class);
        if (argNameAnnotation != null) {
            return argNameAnnotation.value();
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, parameter.getName());
    }

    @NotNull
    private String getArgumentDescription(List<String> argDescriptions, @NotNull Parameter parameter, int index) {
        Description description = parameter.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        if (index < argDescriptions.size()) {
            return argDescriptions.get(index);
        }
        return "";
    }

    @NotNull
    protected String descriptionOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        Description descriptionAnnotation = commandClass.getAnnotation(Description.class);
        if (descriptionAnnotation != null) {
            return descriptionAnnotation.value();
        }
        return "";
    }

    @NotNull
    private Class<?> getGenericType(@NotNull Parameter parameter) {
        Class<?> type = parameter.getType();
        if (SUPPORTED_COLLECTIONS.stream().anyMatch(it -> it.isAssignableFrom(type))) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            Type[] types = parameterizedType.getActualTypeArguments();
            if (types.length != 1) {
                throw this.createException("Unsupported collection type \"" + type + "\"");
            }
            Type genericType = types[0];
            return (Class)(genericType instanceof WildcardType ? ((WildcardType)genericType).getUpperBounds()[0] : genericType);
        }
        return type;
    }

    private Map<SuggestionKey, InternalSuggestion<S, ST>> collectLocalSuggestions() {
        HashMap<SuggestionKey, InternalSuggestion<S, ST>> suggestions = new HashMap<SuggestionKey, InternalSuggestion<S, ST>>();
        for (Method method : this.invocationInstance.getClass().getDeclaredMethods()) {
            SimpleSuggestionHolder.AbstractLocal holder;
            boolean needsContext;
            Parameter parameter;
            Suggestion suggestionAnnotation = method.getAnnotation(Suggestion.class);
            if (suggestionAnnotation == null) continue;
            Type returnType = method.getGenericReturnType();
            if (!(returnType instanceof ParameterizedType)) {
                throw this.createException("Suggestion method must return a List");
            }
            Parameter[] parameters = method.getParameters();
            if (parameters.length > 1) {
                throw this.createException("Suggestion method must have either context as first parameter or no parameters at all");
            }
            Parameter parameter2 = parameter = parameters.length == 1 ? parameters[0] : null;
            if (parameter == null) {
                needsContext = false;
            } else {
                if (parameter.getType() != SuggestionContext.class) {
                    throw this.createException("Suggestion method must have either context as first parameter or no parameters at all");
                }
                needsContext = true;
            }
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (parameterizedType.getRawType() != List.class) {
                throw this.createException("Suggestion method must return a List of suggestions");
            }
            SuggestionKey key = SuggestionKey.of(suggestionAnnotation.value());
            Type listType = parameterizedType.getActualTypeArguments()[0];
            if (listType.equals(String.class)) {
                holder = new SimpleSuggestionHolder.SimpleLocal(this.suggestionMapper, this.invocationInstance, method, needsContext);
                suggestions.put(key, new SimpleSuggestion(holder, this.suggestionMapper, suggestionAnnotation.method()));
                continue;
            }
            if (!listType.equals(this.suggestionMapper.getType())) {
                throw this.createException("Suggestion method must return a List of strings or a List of '" + this.suggestionMapper.getType().getSimpleName() + "'");
            }
            holder = new SimpleSuggestionHolder.RichLocal(this.invocationInstance, method, needsContext);
            suggestions.put(key, new SimpleSuggestion(holder, this.suggestionMapper, suggestionAnnotation.method()));
        }
        return suggestions;
    }

    @NotNull
    private InternalSuggestion<S, ST> suggestionFromParam(@NotNull Parameter parameter) {
        Suggestion annotation = parameter.getAnnotation(Suggestion.class);
        SuggestionKey suggestionKey = annotation == null ? null : SuggestionKey.of(annotation.value());
        Class<?> type = this.getGenericType(parameter);
        SuggestionMethod method = annotation == null ? SuggestionMethod.STARTS_WITH : annotation.method();
        String extra = annotation == null ? "" : annotation.extra();
        return this.createSuggestion(suggestionKey, type, method, extra);
    }

    @NotNull
    protected InternalSuggestion<S, ST> createSuggestion(@Nullable SuggestionKey suggestionKey, @NotNull Class<?> type, @NotNull SuggestionMethod method, @NotNull String extra) {
        if (suggestionKey == null || suggestionKey.getKey().isEmpty()) {
            if (Enum.class.isAssignableFrom(type)) {
                return new EnumSuggestion(type, this.suggestionMapper, method, this.commandOptions.suggestLowercaseEnum());
            }
            InternalSuggestion<S, ST> suggestion = this.suggestionRegistry.getSuggestion(type);
            if (suggestion != null) {
                return suggestion;
            }
            return new EmptySuggestion();
        }
        InternalSuggestion<S, ST> suggestion = this.suggestionRegistry.getSuggestion(suggestionKey);
        if (suggestion == null) {
            InternalSuggestion<S, ST> localSuggestion = this.localSuggestions.get(suggestionKey);
            if (localSuggestion != null) {
                return localSuggestion.copy(method, extra);
            }
            throw this.createException("Cannot find the suggestion key `" + suggestionKey + "`");
        }
        return suggestion.copy(method, extra);
    }
}

