/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.command.InternalCommand;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.extension.CommandOptions;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.ValidationResult;
import dev.triumphteam.cmd.core.extension.command.CommandExecutor;
import dev.triumphteam.cmd.core.extension.command.Settings;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.extension.meta.MetaKey;
import dev.triumphteam.cmd.core.extension.registry.MessageRegistry;
import dev.triumphteam.cmd.core.extension.sender.SenderExtension;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.context.MessageContext;
import dev.triumphteam.cmd.core.message.context.SyntaxMessageContext;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import dev.triumphteam.cmd.core.processor.LeafCommandProcessor;
import dev.triumphteam.cmd.core.util.Pair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalLeafCommand<D, S, ST>
implements InternalCommand<D, S, ST> {
    private final Class<? extends S> senderType;
    private final List<InternalArgument<S, ST>> argumentList;
    private final Map<String, InternalArgument<S, ST>> argumentMap;
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String syntax;
    private final boolean containsLimitless;
    private final CommandMeta meta;
    private final Settings<D, S> settings;
    private final Object invocationInstance;
    private final Method method;
    private final CommandExecutor<S> commandExecutor;
    private final SenderExtension<D, S> senderExtension;
    private final MessageRegistry<S> messageRegistry;

    public InternalLeafCommand(@NotNull Object invocationInstance, @NotNull Method method, @NotNull LeafCommandProcessor<D, S, ST> processor, @NotNull InternalCommand<D, S, ST> parentCommand) {
        Settings.Builder settingsBuilder = new Settings.Builder();
        processor.captureRequirements(settingsBuilder);
        this.meta = processor.createMeta(settingsBuilder);
        this.invocationInstance = invocationInstance;
        this.method = method;
        this.name = processor.getName();
        this.aliases = processor.getAliases();
        this.description = this.meta.getOrDefault(MetaKey.DESCRIPTION, "");
        this.senderType = processor.senderType();
        this.argumentList = processor.arguments(this.meta);
        this.argumentMap = this.argumentList.stream().map(argument -> new Pair<String, InternalArgument>(argument.getName(), (InternalArgument)argument)).collect(Collectors.toMap(Pair::first, Pair::second));
        this.containsLimitless = this.argumentList.stream().anyMatch(LimitlessInternalArgument.class::isInstance);
        CommandOptions commandOptions = processor.getCommandOptions();
        this.messageRegistry = processor.getRegistryContainer().getMessageRegistry();
        this.senderExtension = commandOptions.getCommandExtensions().getSenderExtension();
        this.commandExecutor = commandOptions.getCommandExtensions().getCommandExecutor();
        this.syntax = this.createSyntax(parentCommand, processor);
        this.settings = settingsBuilder.build();
    }

    public void execute(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Map<String, ArgumentInput> arguments) throws Throwable {
        ValidationResult<MessageKey<MessageContext>> validationResult = this.senderExtension.validate(this.meta, this.senderType, sender);
        if (validationResult instanceof ValidationResult.Invalid) {
            this.messageRegistry.sendMessage((MessageKey)((ValidationResult.Invalid)validationResult).getMessage(), sender, new SyntaxMessageContext(this.meta, this.syntax));
            return;
        }
        if (!this.settings.testRequirements(this.messageRegistry, sender, this.meta, this.senderExtension)) {
            return;
        }
        ArrayList<Object> invokeArguments = new ArrayList<Object>();
        invokeArguments.add(sender);
        if (!this.containsLimitless && arguments.size() > this.argumentList.size()) {
            this.messageRegistry.sendMessage(MessageKey.TOO_MANY_ARGUMENTS, sender, new SyntaxMessageContext(this.meta, this.syntax));
            return;
        }
        for (InternalArgument<S, ST> internalArgument : this.argumentList) {
            InternalArgumentResult result;
            ArgumentInput argumentInput = arguments.get(internalArgument.getName());
            if (internalArgument instanceof LimitlessInternalArgument) {
                LimitlessInternalArgument limitlessArgument = (LimitlessInternalArgument)internalArgument;
                result = limitlessArgument.resolve(sender, argumentInput == null ? new ArgumentInput("") : argumentInput);
            } else if (internalArgument instanceof StringInternalArgument) {
                StringInternalArgument stringArgument = (StringInternalArgument)internalArgument;
                ArgumentInput usableInput = argumentInput;
                if (argumentInput == null || argumentInput.getInput().isEmpty()) {
                    if (internalArgument.isOptional()) {
                        String defaultValue = stringArgument.getDefaultValue();
                        if (defaultValue == null) {
                            invokeArguments.add(null);
                            continue;
                        }
                        usableInput = new ArgumentInput(defaultValue);
                    } else {
                        this.messageRegistry.sendMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, sender, new SyntaxMessageContext(this.meta, this.syntax));
                        return;
                    }
                }
                result = stringArgument.resolve(sender, usableInput);
            } else {
                throw new CommandExecutionException("Found unsupported argument", "", this.name);
            }
            if (result instanceof InternalArgumentResult.Invalid) {
                this.messageRegistry.sendMessage(MessageKey.INVALID_ARGUMENT, sender, ((InternalArgumentResult.Invalid)result).getFail().apply(this.meta, this.syntax));
                return;
            }
            if (!(result instanceof InternalArgumentResult.Valid)) continue;
            invokeArguments.add(((InternalArgumentResult.Valid)result).getValue());
        }
        this.commandExecutor.execute(this.meta, this.messageRegistry, sender, instanceSupplier == null ? this.invocationInstance : instanceSupplier.get(), this.method, invokeArguments);
    }

    @NotNull
    public Map<String, ArgumentInput> mapArguments(@NotNull Deque<String> arguments) {
        HashMap<String, ArgumentInput> mappedArguments = new HashMap<String, ArgumentInput>();
        int index = 0;
        while (!arguments.isEmpty()) {
            String arg = arguments.peek();
            InternalArgument<S, ST> internalArgument = this.getArgument(index);
            if (internalArgument == null || arg.isEmpty()) {
                mappedArguments.put(String.valueOf(index), new ArgumentInput(arg));
                arguments.pop();
                ++index;
                continue;
            }
            ++index;
            if (internalArgument instanceof LimitlessInternalArgument) {
                mappedArguments.put(internalArgument.getName(), new ArgumentInput(String.join((CharSequence)" ", arguments)));
                break;
            }
            if (!(internalArgument instanceof StringInternalArgument)) {
                throw new CommandExecutionException("Found unsupported argument", "", this.name);
            }
            arguments.pop();
            mappedArguments.put(internalArgument.getName(), new ArgumentInput(arg));
        }
        return mappedArguments;
    }

    @NotNull
    public List<ST> suggestions(@NotNull S sender, @NotNull List<String> arguments) {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        int index = arguments.size() - 1;
        InternalArgument<S, ST> currentArgument = this.getArgumentFromIndex(index);
        if (currentArgument == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> argumentsMap = new HashMap<String, String>();
        for (int i = 0; i < this.argumentList.size(); ++i) {
            InternalArgument<S, ST> argument = this.argumentList.get(i);
            if (i >= arguments.size()) continue;
            argumentsMap.put(argument.getName(), arguments.get(i));
        }
        if (arguments.isEmpty()) {
            return currentArgument.suggestions(sender, "", arguments, argumentsMap);
        }
        String current = arguments.get(index);
        return currentArgument.suggestions(sender, current, arguments, argumentsMap);
    }

    @Nullable
    public InternalArgument<S, ST> getArgumentFromIndex(int index) {
        if (!this.hasArguments()) {
            return null;
        }
        int size = this.argumentList.size();
        if (index >= size) {
            InternalArgument<S, ST> last = this.argumentList.get(size - 1);
            if (last instanceof LimitlessInternalArgument) {
                return last;
            }
            return null;
        }
        return this.argumentList.get(index);
    }

    @NotNull
    private String createSyntax(@NotNull InternalCommand<D, S, ST> parentCommand, @NotNull CommandProcessor<D, S, ST> processor) {
        Syntax syntaxAnnotation = processor.getSyntaxAnnotation();
        if (syntaxAnnotation != null) {
            return syntaxAnnotation.value();
        }
        StringBuilder builder = new StringBuilder(parentCommand.getSyntax());
        if (!"th-default".equals(this.name)) {
            builder.append(" ").append(this.name);
        }
        this.argumentList.forEach(argument -> builder.append(" ").append("<").append(argument.getName()).append(">"));
        return builder.toString();
    }

    @Override
    @NotNull
    public CommandMeta getMeta() {
        return this.meta;
    }

    @Override
    @NotNull
    public Settings<D, S> getCommandSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @NotNull
    public List<InternalArgument<S, ST>> getArgumentList() {
        return this.argumentList;
    }

    @Nullable
    public InternalArgument<S, ST> getArgument(int index) {
        if (index >= this.argumentList.size()) {
            return null;
        }
        return this.argumentList.get(index);
    }

    @Nullable
    public InternalArgument<S, ST> getArgument(@NotNull String name) {
        return this.argumentMap.get(name);
    }

    @Override
    public boolean isDefault() {
        return this.name.equals("th-default");
    }

    @Override
    public boolean isHidden() {
        return this.isDefault();
    }

    @Override
    public boolean hasArguments() {
        return !this.argumentList.isEmpty();
    }
}

