/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.keyed;

import dev.triumphteam.cmd.core.argument.keyed.Argument;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListArgument
implements Argument {
    private final String name;
    private final String longName;
    private final Class<?> collectionType;
    private final String separator;
    private final Class<?> type;
    private final String description;
    private final SuggestionKey suggestionKey;
    private final boolean isLongNameArgument;

    public ListArgument(@NotNull Argument.CollectionBuilder argumentBuilder) {
        this.type = argumentBuilder.getType();
        this.name = argumentBuilder.getName();
        this.longName = argumentBuilder.getLongName();
        this.description = argumentBuilder.getDescription();
        this.suggestionKey = argumentBuilder.getSuggestionKey();
        this.collectionType = argumentBuilder.getCollectionType();
        this.separator = argumentBuilder.getSeparator();
        this.isLongNameArgument = false;
    }

    public ListArgument(String name, String longName, Class<?> collectionType, String separator, Class<?> type, String description, SuggestionKey suggestionKey, boolean isLongNameArgument) {
        this.name = name;
        this.longName = longName;
        this.collectionType = collectionType;
        this.separator = separator;
        this.type = type;
        this.description = description;
        this.suggestionKey = suggestionKey;
        this.isLongNameArgument = isLongNameArgument;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getLongName() {
        return this.longName;
    }

    @Override
    @NotNull
    public Argument asLongNameArgument() {
        return new ListArgument(this.name, this.longName, this.collectionType, this.separator, this.type, this.description, this.suggestionKey, true);
    }

    @Override
    public boolean isLongNameArgument() {
        return this.isLongNameArgument;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public SuggestionKey getSuggestion() {
        return this.suggestionKey;
    }

    @NotNull
    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    @NotNull
    public String getSeparator() {
        return this.separator;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListArgument that = (ListArgument)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.longName, that.longName) && Objects.equals(this.collectionType, that.collectionType) && Objects.equals(this.separator, that.separator) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description) && Objects.equals(this.suggestionKey, that.suggestionKey);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.longName, this.collectionType, this.separator, this.type, this.description, this.suggestionKey);
    }

    public String toString() {
        return "ListArgument{suggestionKey=" + this.suggestionKey + ", description='" + this.description + '\'' + ", type=" + this.type + ", separator='" + this.separator + '\'' + ", collectionType=" + this.collectionType + ", longName='" + this.longName + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

