/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.keyed;

import dev.triumphteam.cmd.core.argument.keyed.ArgumentValue;
import dev.triumphteam.cmd.core.argument.keyed.FlagsContainer;
import dev.triumphteam.cmd.core.argument.keyed.SimpleArgumentValue;
import dev.triumphteam.cmd.core.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyedArguments
extends FlagsContainer {
    private final Map<String, ArgumentValue> values;
    private final List<String> nonTokens;

    public KeyedArguments(@NotNull Map<String, ArgumentValue> values, @NotNull Map<String, ArgumentValue> flags, @NotNull List<String> nonTokens) {
        super(flags);
        this.values = values;
        this.nonTokens = nonTokens;
    }

    @Override
    @NotNull
    public <T> Optional<T> getArgument(@NotNull String name, @NotNull Class<T> type) {
        return Optional.ofNullable(this.getValue(name));
    }

    @Override
    @NotNull
    public <T> Optional<List<T>> getListArgument(@NotNull String name, @NotNull Class<T> type) {
        List value = (List)this.getValue(name);
        return Optional.ofNullable(value);
    }

    @Override
    @NotNull
    public <T> Optional<Set<T>> getSetArgument(@NotNull String name, @NotNull Class<T> type) {
        Set value = (Set)this.getValue(name);
        return Optional.ofNullable(value);
    }

    @Nullable
    private Object getValue(@NotNull String name) {
        ArgumentValue argumentValue = this.values.get(name);
        if (argumentValue == null) {
            return null;
        }
        if (argumentValue instanceof SimpleArgumentValue) {
            return ((SimpleArgumentValue)argumentValue).getValue();
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, Object> getAllArguments() {
        return this.values.entrySet().stream().map(entry -> {
            ArgumentValue value = (ArgumentValue)entry.getValue();
            if (value instanceof SimpleArgumentValue) {
                return new Pair<String, Object>((String)entry.getKey(), ((SimpleArgumentValue)value).getValue());
            }
            return new Pair<String, Object>((String)entry.getKey(), null);
        }).collect(Collectors.toMap(Pair::first, Pair::second));
    }

    @Override
    @NotNull
    public String getText() {
        return this.getText(" ");
    }

    @Override
    @NotNull
    public String getText(@NotNull String delimiter) {
        return String.join((CharSequence)delimiter, this.nonTokens);
    }

    @Override
    public boolean hasArguments() {
        return !this.values.isEmpty();
    }

    @Override
    @NotNull
    public String toString() {
        return "Arguments{values=" + this.values + ", super=" + super.toString() + "}";
    }
}

