/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import dev.triumphteam.cmd.core.util.EnumUtils;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumInternalArgument<S, ST>
extends StringInternalArgument<S, ST> {
    private final Class<? extends Enum<?>> enumType;

    public EnumInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Class<? extends Enum<?>> type, @NotNull InternalSuggestion<S, ST> suggestion, @Nullable String defaultValue, boolean optional) {
        super(meta, name, description, type, suggestion, defaultValue, optional);
        this.enumType = type;
        EnumUtils.populateCache(type);
    }

    @Override
    @NotNull
    public InternalArgumentResult resolve(@NotNull S sender, @NotNull ArgumentInput input) {
        String value = input.getInput();
        WeakReference<Enum<?>> reference = EnumUtils.getEnumConstants(this.enumType).get(value.toUpperCase());
        if (reference == null) {
            return InternalArgument.invalid((meta, syntax) -> new InvalidArgumentContext((CommandMeta)meta, (String)syntax, value, this.getName(), this.getType()));
        }
        Enum enumValue = (Enum)reference.get();
        if (enumValue == null) {
            return InternalArgument.invalid((commands, arguments) -> new InvalidArgumentContext((CommandMeta)commands, (String)arguments, value, this.getName(), this.getType()));
        }
        return InternalArgument.valid(enumValue);
    }

    @Override
    @NotNull
    public String toString() {
        return "EnumArgument{enumType=" + this.enumType + ", super=" + super.toString() + "}";
    }
}

