/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.bukkit;

import dev.triumphteam.cmd.bukkit.CommandPermission;
import dev.triumphteam.cmd.bukkit.PermissionRequirement;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.extension.annotation.ProcessorTarget;
import dev.triumphteam.cmd.core.extension.command.Processor;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PermissionProcessor<S>
implements Processor<CommandSender, S> {
    private final CommandPermission globalPermission;

    public PermissionProcessor(@Nullable CommandPermission globalPermission) {
        this.globalPermission = globalPermission;
    }

    @Override
    public void process(@NotNull AnnotatedElement element, @NotNull ProcessorTarget target, @NotNull @NotNull @NotNull CommandMeta.Builder meta, @NotNull  @NotNull @NotNull Settings.Builder<CommandSender, S> settingsBuilder) {
        Permission permissionAnnotation = element.getAnnotation(Permission.class);
        if (permissionAnnotation == null) {
            return;
        }
        CommandPermission parentPermission = this.permissionRecursively(meta);
        CommandPermission permission = parentPermission != null ? parentPermission.child(Arrays.asList(permissionAnnotation.value()), permissionAnnotation.description(), permissionAnnotation.def()) : (this.globalPermission != null ? this.globalPermission.child(Arrays.asList(permissionAnnotation.value()), permissionAnnotation.description(), permissionAnnotation.def()) : new CommandPermission(Arrays.asList(permissionAnnotation.value()), permissionAnnotation.description(), permissionAnnotation.def()));
        meta.add(Permission.META_KEY, permission);
        settingsBuilder.addRequirement(new PermissionRequirement(permission));
    }

    @Nullable
    private CommandPermission permissionRecursively(@Nullable CommandMeta meta) {
        if (meta == null) {
            return null;
        }
        CommandPermission permission = meta.getNullable(Permission.META_KEY);
        if (permission != null) {
            return permission;
        }
        return this.permissionRecursively(meta.getParentMeta());
    }
}

