/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.utils;

import com.badbones69.crazyvouchers.CrazyVouchers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import libs.com.ryderbelserion.fusion.core.utils.StringUtils;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.builders.ItemBuilder;
import libs.com.ryderbelserion.fusion.paper.builders.types.PatternBuilder;
import libs.com.ryderbelserion.fusion.paper.builders.types.PotionBuilder;
import libs.com.ryderbelserion.fusion.paper.builders.types.SkullBuilder;
import libs.com.ryderbelserion.fusion.paper.builders.types.SpawnerBuilder;
import libs.com.ryderbelserion.fusion.paper.builders.types.custom.CustomBuilder;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemType;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    @NotNull
    private static final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    private static final ComponentLogger logger = plugin.getComponentLogger();
    @NotNull
    private static final FusionPaper fusion = plugin.getFusion();
    @NotNull
    private static final StringUtils utils = fusion.getStringUtils();

    public static ItemBuilder convertString(@NotNull String itemString) {
        return ItemUtils.convertString(itemString, "");
    }

    public static List<ItemBuilder> convertConfigurationSection(@Nullable ConfigurationSection section) {
        ArrayList<ItemBuilder> cache = new ArrayList<ItemBuilder>();
        if (section == null) {
            return cache;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection patterns;
            String player;
            ConfigurationSection item = section.getConfigurationSection(key);
            if (item == null) continue;
            ItemBuilder itemBuilder = new ItemBuilder(item.getString("material", "stone"));
            itemBuilder.withBase64(item.getString("data", ""));
            itemBuilder.withDisplayName(item.getString("name", ""));
            itemBuilder.withDisplayLore(item.getStringList("lore"));
            itemBuilder.setAmount(item.getInt("amount", 1));
            ConfigurationSection enchantments = item.getConfigurationSection("enchantments");
            if (enchantments != null) {
                for (String enchantment : enchantments.getKeys(false)) {
                    int level = enchantments.getInt(enchantment);
                    itemBuilder.addEnchantment(enchantment, level);
                }
            }
            CustomBuilder customBuilder = itemBuilder.asCustomBuilder();
            customBuilder.setCustomModelData(item.getString("custom-model-data", ""));
            if (item.getBoolean("hide-tool-tip", false)) {
                itemBuilder.hideToolTip();
            }
            if (item.contains("hide-tooltip-advanced") && item.isList("hide-tooltip-advanced")) {
                itemBuilder.hideComponents(item.getStringList("hide-tooltip-advanced"));
            }
            customBuilder.setItemModel(item.getString("item-model.namespace", ""), item.getString("item-model.key", ""));
            itemBuilder.setUnbreakable(item.getBoolean("unbreakable-item", false));
            if (item.contains("settings.glowing")) {
                itemBuilder.addEnchantGlint(item.getBoolean("settings.glowing", false));
            }
            if ((player = item.getString("settings.player", null)) != null && !player.isEmpty()) {
                SkullBuilder skullBuilder = itemBuilder.asSkullBuilder();
                skullBuilder.withName(player).build();
            }
            itemBuilder.setItemDamage(item.getInt("settings.damage", 0));
            itemBuilder.withSkull(item.getString("settings.skull", ""));
            String rgb = item.getString("settings.rgb", "");
            String color = item.getString("settings.color", "");
            itemBuilder.setColor(!color.isEmpty() ? color : (!rgb.isEmpty() ? rgb : ""));
            String mobType = item.getString("settings.mob.type", null);
            if (mobType != null && !mobType.isEmpty()) {
                SpawnerBuilder spawnerBuilder = itemBuilder.asSpawnerBuilder();
                spawnerBuilder.withEntityType(libs.com.ryderbelserion.fusion.paper.utils.ItemUtils.getEntity(mobType)).build();
            }
            itemBuilder.setTrim(item.getString("settings.trim.pattern", ""), item.getString("settings.trim.material", ""));
            ConfigurationSection potions = item.getConfigurationSection("settings.potions");
            if (potions != null) {
                PotionBuilder potionBuilder = itemBuilder.asPotionBuilder();
                for (String potion : potions.getKeys(false)) {
                    ConfigurationSection data;
                    PotionEffectType type = libs.com.ryderbelserion.fusion.paper.utils.ItemUtils.getPotionEffect(potion);
                    if (type == null || (data = potions.getConfigurationSection(potion)) == null) continue;
                    int duration = data.getInt("duration", 10) * 20;
                    int level = data.getInt("level", 1);
                    boolean icon = data.getBoolean("style.icon", false);
                    boolean ambient = data.getBoolean("style.ambient", false);
                    boolean particles = data.getBoolean("style.particles", false);
                    potionBuilder.withPotionEffect(type, duration, level, ambient, particles, icon);
                }
                potionBuilder.build();
            }
            if ((patterns = item.getConfigurationSection("settings.patterns")) != null) {
                for (String pattern : patterns.getKeys(false)) {
                    String patternColor = patterns.getString(pattern, "white");
                    PatternBuilder patternBuilder = itemBuilder.asPatternBuilder();
                    patternBuilder.addPattern(pattern, patternColor);
                    patternBuilder.build();
                }
            }
            customBuilder.build();
            cache.add(itemBuilder);
        }
        return cache;
    }

    public static ItemBuilder convertString(@NotNull String itemString, @NotNull String placeHolder) {
        ItemBuilder itemBuilder = new ItemBuilder((ItemType)ItemType.STONE);
        try {
            block36: for (String optionString : itemString.split(", ")) {
                String option = optionString.split(":")[0];
                String value = optionString.replace(option + ":", "").replace(option, "");
                switch (option.toLowerCase()) {
                    case "item": {
                        itemBuilder.withCustomItem(value.toLowerCase());
                        continue block36;
                    }
                    case "name": {
                        itemBuilder.withDisplayName(value);
                        continue block36;
                    }
                    case "amount": {
                        try {
                            itemBuilder.setAmount(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            itemBuilder.setAmount(1);
                        }
                        continue block36;
                    }
                    case "damage": {
                        try {
                            itemBuilder.setItemDamage(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            itemBuilder.setItemDamage(0);
                        }
                        continue block36;
                    }
                    case "lore": {
                        itemBuilder.withDisplayLore(Arrays.asList(value.split(",")));
                        continue block36;
                    }
                    case "player": {
                        try {
                            itemBuilder.asSkullBuilder().withName(value).build();
                        }
                        catch (Exception exception) {
                            fusion.log("warn", "Could create skull builder because the item is not a player head. You can ignore this, This is a restriction of the current system.", new Object[0]);
                        }
                        continue block36;
                    }
                    case "skull": {
                        itemBuilder.withSkull(value);
                        continue block36;
                    }
                    case "unbreakable-item": {
                        itemBuilder.setUnbreakable(utils.tryParseBoolean(value).orElse(false));
                        continue block36;
                    }
                    case "custom-model-data": {
                        itemBuilder.asCustomBuilder().setCustomModelData(value);
                        continue block36;
                    }
                    case "hide-tool-tip": {
                        itemBuilder.hideToolTip();
                        continue block36;
                    }
                    case "trim": {
                        String[] split = value.split("!");
                        String trim = split[0];
                        String material = split[1];
                        itemBuilder.setTrim(trim.toLowerCase(), material.toLowerCase());
                        continue block36;
                    }
                    case "glowing": {
                        itemBuilder.addEnchantGlint(utils.tryParseBoolean(value).orElse(false));
                        continue block36;
                    }
                    default: {
                        Enchantment enchantment = libs.com.ryderbelserion.fusion.paper.utils.ItemUtils.getEnchantment(ItemUtils.getEnchant(option));
                        if (enchantment != null) {
                            Optional<Number> level = utils.tryParseInt(value);
                            itemBuilder.addEnchantment(ItemUtils.getEnchant(option), level.map(Number::intValue).orElse(1));
                        }
                        if (!itemBuilder.isBanner() && !itemBuilder.isShield()) continue block36;
                        PatternBuilder builder = itemBuilder.asPatternBuilder();
                        builder.addPattern(value, option).build();
                    }
                }
            }
        }
        catch (Exception exception) {
            ((ItemBuilder)((ItemBuilder)itemBuilder.withType((ItemType)ItemType.RED_TERRACOTTA)).withDisplayName("<red>ERROR")).withDisplayLore(Arrays.asList("<red>There is an error", "<red>For : <red>" + placeHolder));
            exception.printStackTrace();
        }
        return itemBuilder;
    }

    public static List<ItemBuilder> convertStringList(@NotNull List<String> itemStrings) {
        return ItemUtils.convertStringList(itemStrings, "");
    }

    public static List<ItemBuilder> convertStringList(@NotNull List<String> itemStrings, @NotNull String placeholder) {
        return itemStrings.stream().map(itemString -> ItemUtils.convertString(itemString, placeholder)).collect(Collectors.toList());
    }

    public static String getEnchant(@NotNull String enchant) {
        if (enchant.isEmpty()) {
            return "";
        }
        switch (enchant) {
            case "PROTECTION_ENVIRONMENTAL": {
                return "protection";
            }
            case "PROTECTION_FIRE": {
                return "fire_protection";
            }
            case "PROTECTION_FALL": {
                return "feather_falling";
            }
            case "PROTECTION_EXPLOSIONS": {
                return "blast_protection";
            }
            case "PROTECTION_PROJECTILE": {
                return "projectile_protection";
            }
            case "OXYGEN": {
                return "respiration";
            }
            case "WATER_WORKER": {
                return "aqua_affinity";
            }
            case "DAMAGE_ALL": {
                return "sharpness";
            }
            case "DAMAGE_UNDEAD": {
                return "smite";
            }
            case "DAMAGE_ARTHROPODS": {
                return "bane_of_arthropods";
            }
            case "LOOT_BONUS_MOBS": {
                return "looting";
            }
            case "SWEEPING_EDGE": {
                return "sweeping";
            }
            case "DIG_SPEED": {
                return "efficiency";
            }
            case "DURABILITY": {
                return "unbreaking";
            }
            case "LOOT_BONUS_BLOCKS": {
                return "fortune";
            }
            case "ARROW_DAMAGE": {
                return "power";
            }
            case "ARROW_KNOCKBACK": {
                return "punch";
            }
            case "ARROW_FIRE": {
                return "flame";
            }
            case "ARROW_INFINITE": {
                return "infinity";
            }
            case "LUCK": {
                return "luck_of_the_sea";
            }
        }
        return enchant.toLowerCase();
    }
}

