/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.support;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.enums.FileSystem;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import libs.org.bstats.bukkit.Metrics;
import libs.org.bstats.charts.SimplePie;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetricsWrapper {
    @NotNull
    private final CrazyVouchers plugin = CrazyVouchers.get();
    @Nullable
    private final Metrics metrics;
    private final SettingsManager config = ConfigManager.getConfig();

    public MetricsWrapper(int serviceId) {
        this.metrics = new Metrics((Plugin)this.plugin, serviceId);
    }

    public void start() {
        if (this.metrics == null || !this.config.getProperty(ConfigKeys.toggle_metrics).booleanValue()) {
            return;
        }
        this.metrics.addCustomChart(new SimplePie("use_dupe_protection", () -> String.valueOf(this.config.getProperty(ConfigKeys.dupe_protection))));
        this.metrics.addCustomChart(new SimplePie("old_file_system", () -> {
            FileSystem system = this.config.getProperty(ConfigKeys.file_system);
            switch (system) {
                case SINGLE: {
                    return "true";
                }
                case MULTIPLE: {
                    return "false";
                }
            }
            return "unknown";
        }));
    }
}

